/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.sql;

import de.willuhn.logging.Logger;
import de.willuhn.util.ConsoleProgessMonitor;
import de.willuhn.util.ProgressMonitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class ScriptExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 2) {
            ScriptExecutor.die("usage: java -cp de_willuhn_util.jar [jdbc-driver] [jdbc-url] < [sql-script.sql]");
        }
        Class.forName(args[0]);
        try (Connection conn = null;){
            conn = DriverManager.getConnection(args[1]);
            ScriptExecutor.execute(new InputStreamReader(System.in), conn, new ConsoleProgessMonitor());
        }
    }

    private static void die(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public static void execute(Reader reader, Connection conn) throws IOException, SQLException {
        ScriptExecutor.execute(reader, conn, null);
    }

    public static void execute(Reader reader, Connection conn, ProgressMonitor monitor) throws IOException, SQLException {
        Statement stmt = null;
        String currentStatement = null;
        boolean commitState = false;
        try {
            BufferedReader br = null;
            String thisLine = null;
            StringBuffer all = new StringBuffer();
            int lines = 0;
            try {
                if (monitor != null) {
                    monitor.setStatusText("reading sql script");
                }
                Logger.debug("reading sql script");
                br = new BufferedReader(reader);
                while ((thisLine = br.readLine()) != null) {
                    if (monitor != null && lines++ % 20 == 0) {
                        monitor.addPercentComplete(1);
                    }
                    if (thisLine.length() <= 0 || thisLine.matches(" *?") || thisLine.startsWith("--") || thisLine.startsWith("\n") || thisLine.startsWith("\r")) continue;
                    all.append(thisLine.trim());
                }
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception e) {
                    Logger.error("error while closing file reader", e);
                }
            }
            String s = all.toString();
            if (s == null || s.length() == 0) {
                Logger.info("no sql statements found in sql script");
                return;
            }
            commitState = conn.getAutoCommit();
            if (monitor != null) {
                monitor.setStatusText("starting transaction");
            }
            Logger.info("starting transaction");
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            if (monitor != null) {
                monitor.setStatusText("executing sql commands");
            }
            String[] commands = s.split(";");
            double factor = 1.0;
            if (monitor != null) {
                factor = (double)(100 - monitor.getPercentComplete()) / (double)commands.length;
                monitor.setStatusText("executing sql commands");
            }
            for (int i = 0; i < commands.length; ++i) {
                if (monitor != null) {
                    monitor.setPercentComplete((int)((double)i * factor));
                }
                if ((currentStatement = commands[i]) == null || currentStatement.length() == 0) continue;
                Logger.debug("executing: " + currentStatement);
                stmt.executeUpdate(currentStatement);
            }
            if (monitor != null) {
                monitor.setStatusText("commit transaction");
            }
            Logger.info("commit transaction");
            conn.commit();
            if (monitor != null) {
                monitor.setPercentComplete(100);
                monitor.setStatus(4);
            }
        }
        catch (SQLException e) {
            if (monitor != null) {
                monitor.setStatus(3);
            }
            try {
                if (conn != null) {
                    if (monitor != null) {
                        monitor.setStatusText("rollback transaction");
                    }
                    Logger.info("rollback transaction");
                    conn.rollback();
                }
            }
            catch (Exception e2) {
                Logger.error("error while rollback connection", e2);
            }
            Logger.error("error while executing sql script. Current statement: " + currentStatement, e);
            throw new SQLException("exception while executing sql script: " + e.getMessage() + ". Current statement: " + currentStatement, currentStatement, e.getErrorCode(), e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e2) {
                Logger.error("error while closing statement", e2);
            }
            try {
                if (conn != null) {
                    conn.setAutoCommit(commitState);
                }
            }
            catch (Exception e3) {
                Logger.error("error while restoring commit state", e3);
            }
        }
    }
}

