/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.security;

import de.willuhn.io.IOUtil;
import de.willuhn.util.Queue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.HashMap;

public class Signature {
    private static final String ALG = "SHA1withRSA";

    private Signature() {
    }

    public static byte[] sign(InputStream data, PrivateKey key) throws GeneralSecurityException, IOException {
        java.security.Signature sig = java.security.Signature.getInstance(ALG);
        sig.initSign(key);
        byte[] buf = new byte[1024];
        int read = 0;
        while ((read = data.read(buf)) != -1) {
            sig.update(buf, 0, read);
        }
        return sig.sign();
    }

    public static boolean verifiy(InputStream data, PublicKey key, byte[] signature) throws GeneralSecurityException, IOException {
        java.security.Signature sig = java.security.Signature.getInstance(ALG);
        sig.initVerify(key);
        byte[] buf = new byte[1024];
        int read = 0;
        while ((read = data.read(buf)) != -1) {
            sig.update(buf, 0, read);
        }
        return sig.verify(signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] args) throws Exception {
        BufferedOutputStream os;
        BufferedInputStream is3;
        BufferedInputStream is2;
        BufferedInputStream is1;
        block17: {
            if (args == null || args.length < 2) {
                Signature.usage();
            }
            Queue queue = new Queue(100);
            for (String s : args) {
                queue.push(s.trim());
            }
            String command = (String)queue.pop();
            if (!command.equals("sign") && !command.equals("verify")) {
                Signature.usage();
            }
            HashMap<String, String> options = new HashMap<String, String>();
            String s = null;
            while (queue.size() > 0) {
                String curr = (String)queue.pop();
                if (curr == null || curr.length() == 0) continue;
                if (curr.startsWith("-")) {
                    s = curr.substring(1);
                    continue;
                }
                options.put(s, curr);
            }
            is1 = null;
            is2 = null;
            is3 = null;
            os = null;
            try {
                String storepass;
                String alias;
                String keyfile = (String)options.get("keystore");
                if (keyfile == null) {
                    Signature.error("no keystore file given");
                }
                if ((alias = (String)options.get("alias")) == null) {
                    alias = "default";
                }
                if ((storepass = (String)options.get("storepass")) == null) {
                    storepass = "";
                }
                is1 = new BufferedInputStream(new FileInputStream(keyfile));
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(is1, storepass.toCharArray());
                String file = (String)options.get("file");
                if (file == null) {
                    Signature.error("no file to sign/verify given");
                }
                is2 = new BufferedInputStream(new FileInputStream(file));
                String sig = (String)options.get("sig");
                if (sig == null) {
                    sig = file + ".sha1";
                }
                if (command.equals("sign")) {
                    PrivateKey key;
                    String keypass = (String)options.get("keypass");
                    if (keypass == null) {
                        keypass = "";
                    }
                    if ((key = (PrivateKey)keyStore.getKey(alias, keypass.toCharArray())) == null) {
                        Signature.error("key for alias \"" + alias + "\" not found");
                    }
                    os = new BufferedOutputStream(new FileOutputStream(sig));
                    ((OutputStream)os).write(Signature.sign(is2, key));
                    System.out.println("signature created");
                    break block17;
                }
                Certificate cert = keyStore.getCertificate(alias);
                if (cert == null) {
                    Signature.error("certificate for alias \"" + alias + "\" not found");
                }
                is3 = new BufferedInputStream(new FileInputStream(sig));
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                int read = 0;
                while ((read = ((InputStream)is3).read(buf)) != -1) {
                    bos.write(buf, 0, read);
                }
                boolean b = Signature.verifiy(is2, cert.getPublicKey(), bos.toByteArray());
                System.out.println("verification " + (b ? "OK" : "FAILED"));
                System.exit(b ? 0 : 1);
            }
            catch (Throwable throwable) {
                IOUtil.close(is1, is2, is3, os);
                throw throwable;
            }
        }
        IOUtil.close(is1, is2, is3, os);
    }

    private static void error(String message) {
        System.err.println(message);
        System.exit(3);
    }

    private static void usage() {
        PrintStream s = System.err;
        s.println("usage: java -cp de_willuhn_util.jar " + Signature.class.getName() + " [sign/verify] [options]\n");
        s.println("  sign  : create a new signature for a file");
        s.println("  verify: check the signature of a file\n");
        s.println("  options:");
        s.println("    -keystore <keystore>     path to keystore file (JKS format)");
        s.println("    -storepass <password>    password of keystore file");
        s.println("    -alias <alias>           alias name of keystore entry (contains public and/or private key)");
        s.println("    -keypass <password>      password of keystore entry (only needed for signing)");
        s.println("    -file <file>             the file to sign/verify");
        s.println("    -sig <file>              the signature file to create/verify");
        s.println("\nexamples:\n");
        s.println("java -cp de_willuhn_util.jar " + Signature.class.getName() + " sign -keystore my.keystore -storepass changeit -alias default -keypass foobar -file de_willuhn_util.jar -sig de_willuhn_util.jar.sig");
        s.println("java -cp de_willuhn_util.jar " + Signature.class.getName() + " verify -keystore my.keystore -storepass changeit -alias default -keypass foobar -file de_willuhn_util.jar -sig de_willuhn_util.jar.sig");
        s.println("");
        s.println("hint: a JKS keystore can be created using the SUN keytool program");
        s.println("\n");
        System.exit(2);
    }
}

