/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.net;

import de.willuhn.logging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class MulticastClient {
    public static final String DEFAULT_ADDRESS = "224.0.0.1";
    public static final int DEFAULT_PORT = 6789;
    private InetAddress self = null;
    private int port = 6789;
    private InetAddress address = null;
    private DatagramPacket packet = null;
    private MulticastSocket socket = null;
    private Worker worker = null;

    public MulticastClient() throws IOException {
        this(DEFAULT_ADDRESS, 6789);
    }

    public MulticastClient(String address, int port) throws IOException {
        this.port = port;
        this.address = InetAddress.getByName(address);
        this.self = InetAddress.getLocalHost();
        this.socket = new MulticastSocket(this.port);
        this.socket.joinGroup(this.address);
        this.worker = new Worker();
        this.worker.start();
    }

    public synchronized void stop() throws IOException {
        this.worker.shutdown();
    }

    public void send(byte[] data) throws IOException {
        Logger.debug("sending " + data.length + " bytes");
        DatagramPacket packet = new DatagramPacket(data, data.length, this.address, this.port);
        this.socket.send(packet);
    }

    public void received(DatagramPacket packet) throws IOException {
        Logger.debug("response from " + packet.getAddress().getHostName() + ": " + new String(packet.getData()));
    }

    public static final void main(String[] args) throws Exception {
        MulticastClient client = new MulticastClient(){

            @Override
            public void received(DatagramPacket packet) throws IOException {
                InetAddress sender = packet.getAddress();
                InetAddress self = InetAddress.getLocalHost();
                System.out.println("\n" + sender.getCanonicalHostName() + "> " + new String(packet.getData()));
                System.out.print(self.getCanonicalHostName() + "> ");
            }
        };
        try {
            System.out.println("type message and press ENTER to send.");
            System.out.println("press CTRL+C to exit.");
            InputStreamReader isr = new InputStreamReader(System.in);
            BufferedReader keyboard = new BufferedReader(isr);
            while (true) {
                System.out.print(client.self.getHostName() + "> ");
                String input = keyboard.readLine();
                if (input == null || input.length() == 0) continue;
                client.send(input.getBytes());
            }
        }
        catch (Throwable throwable) {
            System.out.println("");
            Logger.flush();
            Logger.close();
            client.stop();
            throw throwable;
        }
    }

    private static boolean isOwn(InetAddress address) throws SocketException {
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        while (ifaces.hasMoreElements()) {
            NetworkInterface i = ifaces.nextElement();
            Enumeration<InetAddress> ips = i.getInetAddresses();
            while (ips.hasMoreElements()) {
                if (!address.equals(ips.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    private class Worker
    extends Thread {
        private Worker() {
            this.setName(this.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void shutdown() throws IOException {
            try {
                this.interrupt();
                MulticastClient.this.socket.leaveGroup(MulticastClient.this.address);
            }
            finally {
                MulticastClient.this.socket.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Logger.debug("start: " + this.toString());
                while (!this.isInterrupted()) {
                    byte[] buf = new byte[1024];
                    MulticastClient.this.packet = new DatagramPacket(buf, buf.length);
                    MulticastClient.this.socket.receive(MulticastClient.this.packet);
                    InetAddress sender = MulticastClient.this.packet.getAddress();
                    if (MulticastClient.isOwn(sender)) continue;
                    MulticastClient.this.received(MulticastClient.this.packet);
                }
            }
            catch (SocketException se) {
                if (!this.isInterrupted()) {
                    Logger.error("error while receiving data", se);
                }
            }
            catch (IOException ioe) {
                Logger.error("error while receiving data", ioe);
            }
            finally {
                Logger.debug("stopped: " + this.toString());
            }
        }

        @Override
        public String toString() {
            return "multicast-client " + MulticastClient.this.address.getHostAddress() + ":" + MulticastClient.this.port;
        }
    }
}

