/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.logging.targets;

import de.willuhn.logging.Logger;
import de.willuhn.logging.Message;
import de.willuhn.logging.targets.Target;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class SyslogTarget
implements Target {
    private int port = 514;
    private InetAddress targetHost = null;
    private DatagramSocket socket = null;

    public SyslogTarget(String hostname) throws Exception {
        this(hostname, 514);
    }

    public SyslogTarget(String hostname, int port) throws Exception {
        try {
            this.targetHost = InetAddress.getByName(hostname);
        }
        catch (Exception e) {
            Logger.warn("hostname " + hostname + " invalid, trying localhost");
            this.targetHost = InetAddress.getByName("localhost");
        }
        this.port = port;
        this.socket = new DatagramSocket();
    }

    @Override
    public void write(Message message) throws Exception {
        if (message == null) {
            return;
        }
        String s = "[" + message.getLevel().getName() + "] " + message.getText();
        byte[] data = s.getBytes();
        DatagramPacket packet = new DatagramPacket(data, data.length, this.targetHost, this.port);
        this.socket.send(packet);
    }

    @Override
    public void close() throws Exception {
        this.socket.close();
    }
}

