/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.logging;

import de.willuhn.logging.Level;
import java.util.Date;

public class Message {
    private Date date = null;
    private Level level = null;
    private String host = null;
    private String text = null;
    private String clazz = null;
    private String method = null;
    private String thread = null;

    Message(Date d, Level l, String host, String clazz, String method, String text, String thread) {
        this.date = d;
        this.level = l;
        this.host = host;
        this.clazz = clazz;
        this.method = method;
        this.text = text;
        this.thread = thread;
    }

    public Date getDate() {
        return this.date;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getHost() {
        return this.host;
    }

    public String getText() {
        return this.text;
    }

    public String getThread() {
        return this.thread;
    }

    public String getLoggingClass() {
        return this.clazz;
    }

    public String getLoggingMethod() {
        return this.method;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.host != null && this.host.length() > 0) {
            sb.append("[");
            sb.append(this.host);
            sb.append("]");
        }
        if (this.date != null) {
            sb.append("[");
            sb.append(this.date.toString());
            sb.append("]");
        }
        if (this.level != null) {
            sb.append("[");
            sb.append(this.level.getName());
            sb.append("]");
        }
        if (this.thread != null) {
            sb.append("[");
            sb.append(this.thread);
            sb.append("]");
        }
        if (this.clazz != null && this.method != null) {
            sb.append("[");
            sb.append(this.clazz);
            sb.append(".");
            sb.append(this.method);
            sb.append("]");
        }
        sb.append(" ");
        sb.append(this.text);
        return sb.toString();
    }
}

