/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.io;

import de.willuhn.io.AbstractZipSupport;
import de.willuhn.io.IOUtil;
import de.willuhn.logging.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipExtractor
extends AbstractZipSupport {
    private ZipFile zip = null;

    public ZipExtractor(ZipFile zip) {
        this.zip = zip;
    }

    public void extract(File targetDirectory) throws IOException {
        this.monitor.setStatus(2);
        this.monitor.setStatusText("extracting zip file " + this.zip.getName() + " to " + targetDirectory.getAbsolutePath());
        this.monitor.log("extracting zip file " + this.zip.getName() + " to " + targetDirectory.getAbsolutePath());
        Logger.info("extracting zip file " + this.zip.getName() + " to " + targetDirectory.getAbsolutePath());
        if (!targetDirectory.exists()) {
            this.monitor.log("creating directory " + targetDirectory.getAbsolutePath());
            if (!targetDirectory.mkdirs()) {
                throw new IOException("unable to create target directory " + targetDirectory.getAbsolutePath());
            }
        }
        Enumeration<? extends ZipEntry> entries = this.zip.entries();
        int size = this.zip.size();
        this.monitor.log("uncompressing " + size + " elements");
        String currentName = null;
        File currentFile = null;
        File backup = null;
        int i = 0;
        try {
            while (entries.hasMoreElements()) {
                String path;
                File f;
                ZipEntry entry = entries.nextElement();
                currentName = entry.getName();
                this.monitor.setPercentComplete(i * 100 / size);
                ++i;
                currentFile = new File(targetDirectory, currentName);
                Logger.info(currentName);
                if (entry.isDirectory()) {
                    if (!currentFile.exists()) {
                        Logger.debug("  creating directory");
                        currentFile.mkdirs();
                        continue;
                    }
                    Logger.info("  directory allready exists, skipping");
                    continue;
                }
                int idx = currentName.lastIndexOf(47);
                if (idx >= 0 && !(f = new File(targetDirectory, path = currentName.substring(0, idx))).exists()) {
                    Logger.debug("  creating directory");
                    if (!f.mkdirs()) {
                        throw new IOException("unable to create directory " + f.getAbsolutePath());
                    }
                }
                if (currentFile.exists()) {
                    long fileTime;
                    long zipTime = entry.getTime();
                    if (zipTime > (fileTime = currentFile.lastModified())) {
                        Logger.info("  zip entry is newer, replacing");
                        backup = new File(currentFile.getAbsolutePath() + ".bak");
                        currentFile.renameTo(backup);
                        currentFile = new File(targetDirectory, currentName);
                    } else {
                        Logger.info("  skipping, allready exists");
                        continue;
                    }
                }
                this.monitor.log(currentFile.getAbsolutePath());
                if (!currentFile.createNewFile()) {
                    throw new IOException("unable to create file " + currentFile.getAbsolutePath());
                }
                InputStream is = this.zip.getInputStream(entry);
                if (is == null) {
                    Logger.warn("  entry " + entry.getName() + " not found in archive, skipping");
                    continue;
                }
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(currentFile));
                IOUtil.copy(is, os);
                is.close();
                ((OutputStream)os).flush();
                ((OutputStream)os).close();
                if (backup == null || !backup.exists()) continue;
                backup.delete();
            }
            this.monitor.setPercentComplete(100);
            this.monitor.setStatusText("zip file " + this.zip.getName() + " uncompressed successfully");
            this.monitor.setStatus(4);
        }
        catch (IOException e) {
            this.monitor.setStatus(3);
            try {
                if (backup != null && currentFile != null && backup.exists() && backup.isFile()) {
                    String name = currentFile.getAbsolutePath();
                    if (currentFile.exists() && currentFile.isFile()) {
                        currentFile.delete();
                    }
                    backup.renameTo(new File(name));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        finally {
            if (this.zip != null) {
                try {
                    this.zip.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

