/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.boot;

import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ProgressMonitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class BootLoader {
    private Map<Class, Bootable> services = new HashMap<Class, Bootable>();
    private Stack<Bootable> order = new Stack();
    private int indent = 0;
    private ProgressMonitor dummy = new DummyMonitor();
    private ProgressMonitor monitor = null;

    public final ProgressMonitor getMonitor() {
        return this.monitor == null ? this.dummy : this.monitor;
    }

    public final void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public final <T extends Bootable> T getBootable(Class<? extends Bootable> target) {
        return this.resolve(target, null);
    }

    private final <T extends Bootable> T resolve(Class<? extends Bootable> target, Bootable caller) {
        Bootable s = this.services.get(target);
        if (s != null) {
            return (T)s;
        }
        String name = target.getSimpleName();
        Logger.debug(this.indent() + "booting service " + name);
        ++this.indent;
        try {
            s = target.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("unable to create instance of " + name, e);
        }
        Logger.debug(this.indent() + "checking dependencies for " + name);
        Class<Bootable>[] deps = s.depends();
        if (deps != null && deps.length > 0) {
            Logger.debug(this.indent() + "booting dependencies for " + name);
            for (Class<Bootable> dep : deps) {
                if (dep.equals(target)) {
                    Logger.info(this.indent() + name + " cannot have itself as dependency, skipping");
                    --this.indent;
                    continue;
                }
                this.resolve(dep, s);
            }
        } else {
            Logger.debug(this.indent() + "no dependencies found for " + name);
        }
        try {
            Logger.debug(this.indent() + "init service " + name);
            this.services.put(s.getClass(), s);
            long start = System.currentTimeMillis();
            s.init(this, caller);
            this.order.add(s);
            long used = System.currentTimeMillis() - start;
            Logger.debug("used time to init " + name + ": " + used + " millis");
        }
        catch (SkipServiceException e) {
            this.services.remove(s.getClass());
            Logger.warn(this.indent() + "skipping service " + name + ". message: " + e.getMessage());
        }
        --this.indent;
        return (T)s;
    }

    private String indent() {
        String s = "";
        for (int i = 0; i < this.indent; ++i) {
            s = s + "  ";
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            Bootable service = null;
            while (!this.order.empty()) {
                service = this.order.pop();
                String name = service.getClass().getSimpleName();
                if (this.monitor != null) {
                    this.monitor.setStatusText("shutting down service " + name);
                    this.monitor.addPercentComplete(1);
                }
                Logger.debug("shutting down service " + name);
                service.shutdown();
            }
        }
        finally {
            this.order.clear();
            this.services.clear();
        }
    }

    private class DummyMonitor
    implements ProgressMonitor {
        private DummyMonitor() {
        }

        @Override
        public void setPercentComplete(int percent) {
        }

        @Override
        public void addPercentComplete(int percent) {
        }

        @Override
        public int getPercentComplete() {
            return 0;
        }

        @Override
        public void setStatus(int status) {
        }

        @Override
        public void setStatusText(String text) {
        }

        @Override
        public void log(String msg) {
        }
    }
}

