/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.annotation;

import de.willuhn.annotation.Injector;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Inject {
    public static void inject(Object bean, Class<? extends Annotation> a, final Object value) throws Exception {
        Inject.inject(bean, new Injector(){

            @Override
            public void inject(Object bean, AccessibleObject field, Annotation a) throws Exception {
                field.setAccessible(true);
                if (field instanceof Field) {
                    ((Field)field).set(bean, value);
                } else if (field instanceof Method) {
                    ((Method)field).invoke(bean, value);
                } else {
                    throw new Exception("unable to inject into " + field.getClass().getSimpleName());
                }
            }
        }, a);
    }

    public static void inject(Object bean, Injector injector) throws Exception {
        Inject.inject(bean, injector, new Class[0]);
    }

    public static void inject(Object bean, Injector injector, Class<? extends Annotation> ... annotations) throws Exception {
        Class<?> current = bean.getClass();
        for (int i = 0; i < 100; ++i) {
            Class<?> superClass;
            Method[] methods;
            Field[] fields = current.getDeclaredFields();
            if (fields != null && fields.length > 0) {
                block1: for (Field f : fields) {
                    Annotation[] al = f.getAnnotations();
                    if (al == null || al.length == 0) continue;
                    for (Annotation at : al) {
                        if (!Inject.matchTarget(at, ElementType.FIELD) || !Inject.applicable(annotations, at)) continue;
                        f.setAccessible(true);
                        injector.inject(bean, f, at);
                        continue block1;
                    }
                }
            }
            if ((methods = current.getDeclaredMethods()) != null && methods.length > 0) {
                block3: for (Method m : methods) {
                    Annotation[] al = m.getAnnotations();
                    if (al == null || al.length == 0) continue;
                    for (Annotation at : al) {
                        if (!Inject.matchTarget(at, ElementType.METHOD) || !Inject.applicable(annotations, at)) continue;
                        m.setAccessible(true);
                        injector.inject(bean, m, at);
                        continue block3;
                    }
                }
            }
            if ((superClass = current.getSuperclass()) == null) break;
            current = superClass;
        }
    }

    private static boolean matchTarget(Annotation a, ElementType type) {
        Target target = a.getClass().getAnnotation(Target.class);
        if (target == null) {
            return true;
        }
        ElementType[] types = target.value();
        if (types == null || types.length == 0) {
            return true;
        }
        for (ElementType t : types) {
            if (!t.equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    private static boolean applicable(Class<? extends Annotation>[] list, Annotation a) {
        if (list == null || list.length == 0 || list.length == 1 && list[0] == null) {
            return true;
        }
        for (Class<? extends Annotation> test : list) {
            if (test == null || !a.annotationType().isAssignableFrom(test)) continue;
            return true;
        }
        return false;
    }
}

