# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_ironbar_global_optspecs
	string join \n print-schema print-completions= debug c/config= t/theme= f/format= b= h/help V/version
end

function __fish_ironbar_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_ironbar_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_ironbar_using_subcommand
	set -l cmd (__fish_ironbar_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c ironbar -n "__fish_ironbar_needs_command" -l print-completions -d 'Print shell completions to `stdout` and exit' -r -f -a "bash\t''
elvish\t''
zsh\t''
fish\t''
powershell\t''"
complete -c ironbar -n "__fish_ironbar_needs_command" -s c -l config -d 'Specify the path to the config file to use' -r
complete -c ironbar -n "__fish_ironbar_needs_command" -s t -l theme -r
complete -c ironbar -n "__fish_ironbar_needs_command" -s f -l format -d 'Format to output the response as' -r -f -a "plain\t''
json\t''"
complete -c ironbar -n "__fish_ironbar_needs_command" -s b -d '`bar_id` argument passed by `swaybar_command`. Not used' -r
complete -c ironbar -n "__fish_ironbar_needs_command" -l print-schema -d 'Print the config JSON schema to `stdout` and exit'
complete -c ironbar -n "__fish_ironbar_needs_command" -l debug -d 'Print debug information to stderr'
complete -c ironbar -n "__fish_ironbar_needs_command" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_needs_command" -s V -l version -d 'Print version'
complete -c ironbar -n "__fish_ironbar_needs_command" -f -a "ping" -d 'Pong'
complete -c ironbar -n "__fish_ironbar_needs_command" -f -a "inspect" -d 'Open the GTK inspector'
complete -c ironbar -n "__fish_ironbar_needs_command" -f -a "reload" -d 'Reload the config'
complete -c ironbar -n "__fish_ironbar_needs_command" -f -a "var" -d 'Get and set reactive Ironvar values'
complete -c ironbar -n "__fish_ironbar_needs_command" -f -a "bar" -d 'Interact with a specific bar'
complete -c ironbar -n "__fish_ironbar_needs_command" -f -a "style" -d 'Load stylesheets and dynamically add/remove classes'
complete -c ironbar -n "__fish_ironbar_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ironbar -n "__fish_ironbar_using_subcommand ping" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand inspect" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand reload" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand var; and not __fish_seen_subcommand_from set get list help" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand var; and not __fish_seen_subcommand_from set get list help" -f -a "set" -d 'Set an `ironvar` value. This creates it if it does not already exist, and updates it if it does. Any references to this variable are automatically and immediately updated. Keys and values can be any valid UTF-8 string'
complete -c ironbar -n "__fish_ironbar_using_subcommand var; and not __fish_seen_subcommand_from set get list help" -f -a "get" -d 'Get the current value of an `ironvar`'
complete -c ironbar -n "__fish_ironbar_using_subcommand var; and not __fish_seen_subcommand_from set get list help" -f -a "list" -d 'Gets the current value of all `ironvar`s'
complete -c ironbar -n "__fish_ironbar_using_subcommand var; and not __fish_seen_subcommand_from set get list help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ironbar -n "__fish_ironbar_using_subcommand var; and __fish_seen_subcommand_from set" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand var; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand var; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand var; and __fish_seen_subcommand_from help" -f -a "set" -d 'Set an `ironvar` value. This creates it if it does not already exist, and updates it if it does. Any references to this variable are automatically and immediately updated. Keys and values can be any valid UTF-8 string'
complete -c ironbar -n "__fish_ironbar_using_subcommand var; and __fish_seen_subcommand_from help" -f -a "get" -d 'Get the current value of an `ironvar`'
complete -c ironbar -n "__fish_ironbar_using_subcommand var; and __fish_seen_subcommand_from help" -f -a "list" -d 'Gets the current value of all `ironvar`s'
complete -c ironbar -n "__fish_ironbar_using_subcommand var; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and not __fish_seen_subcommand_from show hide set-visible toggle-visible get-visible show-popup hide-popup set-popup-visible toggle-popup get-popup-visible set-exclusive help" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and not __fish_seen_subcommand_from show hide set-visible toggle-visible get-visible show-popup hide-popup set-popup-visible toggle-popup get-popup-visible set-exclusive help" -a "show" -d 'Force the bar to be shown, regardless of current visibility state'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and not __fish_seen_subcommand_from show hide set-visible toggle-visible get-visible show-popup hide-popup set-popup-visible toggle-popup get-popup-visible set-exclusive help" -a "hide" -d 'Force the bar to be hidden, regardless of current visibility state'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and not __fish_seen_subcommand_from show hide set-visible toggle-visible get-visible show-popup hide-popup set-popup-visible toggle-popup get-popup-visible set-exclusive help" -a "set-visible" -d 'Set the bar\'s visibility state via an argument'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and not __fish_seen_subcommand_from show hide set-visible toggle-visible get-visible show-popup hide-popup set-popup-visible toggle-popup get-popup-visible set-exclusive help" -a "toggle-visible" -d 'Toggle the current visibility state between shown and hidden'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and not __fish_seen_subcommand_from show hide set-visible toggle-visible get-visible show-popup hide-popup set-popup-visible toggle-popup get-popup-visible set-exclusive help" -a "get-visible" -d 'Get the bar\'s visibility state'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and not __fish_seen_subcommand_from show hide set-visible toggle-visible get-visible show-popup hide-popup set-popup-visible toggle-popup get-popup-visible set-exclusive help" -a "show-popup" -d 'Open a popup, regardless of current state. If opening this popup, and a different popup on the same bar is already open, the other is closed'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and not __fish_seen_subcommand_from show hide set-visible toggle-visible get-visible show-popup hide-popup set-popup-visible toggle-popup get-popup-visible set-exclusive help" -a "hide-popup" -d 'Close a popup, regardless of current state'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and not __fish_seen_subcommand_from show hide set-visible toggle-visible get-visible show-popup hide-popup set-popup-visible toggle-popup get-popup-visible set-exclusive help" -a "set-popup-visible" -d 'Set the popup\'s visibility state via an argument. If opening this popup, and a different popup on the same bar is already open, the other is closed'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and not __fish_seen_subcommand_from show hide set-visible toggle-visible get-visible show-popup hide-popup set-popup-visible toggle-popup get-popup-visible set-exclusive help" -a "toggle-popup" -d 'Toggle a popup open/closed. If opening this popup, and a different popup on the same bar is already open, the other is closed'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and not __fish_seen_subcommand_from show hide set-visible toggle-visible get-visible show-popup hide-popup set-popup-visible toggle-popup get-popup-visible set-exclusive help" -a "get-popup-visible" -d 'Get the popup\'s current visibility state'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and not __fish_seen_subcommand_from show hide set-visible toggle-visible get-visible show-popup hide-popup set-popup-visible toggle-popup get-popup-visible set-exclusive help" -a "set-exclusive" -d 'Set whether the bar reserves an exclusive zone'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and not __fish_seen_subcommand_from show hide set-visible toggle-visible get-visible show-popup hide-popup set-popup-visible toggle-popup get-popup-visible set-exclusive help" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from show" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from hide" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from set-visible" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from toggle-visible" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from get-visible" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from show-popup" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from hide-popup" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from set-popup-visible" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from toggle-popup" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from get-popup-visible" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from set-exclusive" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from help" -f -a "show" -d 'Force the bar to be shown, regardless of current visibility state'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from help" -f -a "hide" -d 'Force the bar to be hidden, regardless of current visibility state'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from help" -f -a "set-visible" -d 'Set the bar\'s visibility state via an argument'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from help" -f -a "toggle-visible" -d 'Toggle the current visibility state between shown and hidden'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from help" -f -a "get-visible" -d 'Get the bar\'s visibility state'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from help" -f -a "show-popup" -d 'Open a popup, regardless of current state. If opening this popup, and a different popup on the same bar is already open, the other is closed'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from help" -f -a "hide-popup" -d 'Close a popup, regardless of current state'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from help" -f -a "set-popup-visible" -d 'Set the popup\'s visibility state via an argument. If opening this popup, and a different popup on the same bar is already open, the other is closed'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from help" -f -a "toggle-popup" -d 'Toggle a popup open/closed. If opening this popup, and a different popup on the same bar is already open, the other is closed'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from help" -f -a "get-popup-visible" -d 'Get the popup\'s current visibility state'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from help" -f -a "set-exclusive" -d 'Set whether the bar reserves an exclusive zone'
complete -c ironbar -n "__fish_ironbar_using_subcommand bar; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and not __fish_seen_subcommand_from load-css add-class remove-class toggle-class help" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and not __fish_seen_subcommand_from load-css add-class remove-class toggle-class help" -f -a "load-css" -d 'Load an additional CSS stylesheet. The sheet is automatically hot-reloaded'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and not __fish_seen_subcommand_from load-css add-class remove-class toggle-class help" -f -a "add-class" -d 'Add a CSS class `name` to all modules matching `module_name`'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and not __fish_seen_subcommand_from load-css add-class remove-class toggle-class help" -f -a "remove-class" -d 'Remove a CSS class `name` from all modules matching `module_name`'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and not __fish_seen_subcommand_from load-css add-class remove-class toggle-class help" -f -a "toggle-class" -d 'Toggle a CSS class `name` on all modules matching `module_name`'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and not __fish_seen_subcommand_from load-css add-class remove-class toggle-class help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and __fish_seen_subcommand_from load-css" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and __fish_seen_subcommand_from add-class" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and __fish_seen_subcommand_from remove-class" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and __fish_seen_subcommand_from toggle-class" -s h -l help -d 'Print help'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and __fish_seen_subcommand_from help" -f -a "load-css" -d 'Load an additional CSS stylesheet. The sheet is automatically hot-reloaded'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and __fish_seen_subcommand_from help" -f -a "add-class" -d 'Add a CSS class `name` to all modules matching `module_name`'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and __fish_seen_subcommand_from help" -f -a "remove-class" -d 'Remove a CSS class `name` from all modules matching `module_name`'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and __fish_seen_subcommand_from help" -f -a "toggle-class" -d 'Toggle a CSS class `name` on all modules matching `module_name`'
complete -c ironbar -n "__fish_ironbar_using_subcommand style; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and not __fish_seen_subcommand_from ping inspect reload var bar style help" -f -a "ping" -d 'Pong'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and not __fish_seen_subcommand_from ping inspect reload var bar style help" -f -a "inspect" -d 'Open the GTK inspector'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and not __fish_seen_subcommand_from ping inspect reload var bar style help" -f -a "reload" -d 'Reload the config'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and not __fish_seen_subcommand_from ping inspect reload var bar style help" -f -a "var" -d 'Get and set reactive Ironvar values'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and not __fish_seen_subcommand_from ping inspect reload var bar style help" -f -a "bar" -d 'Interact with a specific bar'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and not __fish_seen_subcommand_from ping inspect reload var bar style help" -f -a "style" -d 'Load stylesheets and dynamically add/remove classes'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and not __fish_seen_subcommand_from ping inspect reload var bar style help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from var" -f -a "set" -d 'Set an `ironvar` value. This creates it if it does not already exist, and updates it if it does. Any references to this variable are automatically and immediately updated. Keys and values can be any valid UTF-8 string'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from var" -f -a "get" -d 'Get the current value of an `ironvar`'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from var" -f -a "list" -d 'Gets the current value of all `ironvar`s'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from bar" -f -a "show" -d 'Force the bar to be shown, regardless of current visibility state'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from bar" -f -a "hide" -d 'Force the bar to be hidden, regardless of current visibility state'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from bar" -f -a "set-visible" -d 'Set the bar\'s visibility state via an argument'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from bar" -f -a "toggle-visible" -d 'Toggle the current visibility state between shown and hidden'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from bar" -f -a "get-visible" -d 'Get the bar\'s visibility state'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from bar" -f -a "show-popup" -d 'Open a popup, regardless of current state. If opening this popup, and a different popup on the same bar is already open, the other is closed'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from bar" -f -a "hide-popup" -d 'Close a popup, regardless of current state'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from bar" -f -a "set-popup-visible" -d 'Set the popup\'s visibility state via an argument. If opening this popup, and a different popup on the same bar is already open, the other is closed'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from bar" -f -a "toggle-popup" -d 'Toggle a popup open/closed. If opening this popup, and a different popup on the same bar is already open, the other is closed'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from bar" -f -a "get-popup-visible" -d 'Get the popup\'s current visibility state'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from bar" -f -a "set-exclusive" -d 'Set whether the bar reserves an exclusive zone'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from style" -f -a "load-css" -d 'Load an additional CSS stylesheet. The sheet is automatically hot-reloaded'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from style" -f -a "add-class" -d 'Add a CSS class `name` to all modules matching `module_name`'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from style" -f -a "remove-class" -d 'Remove a CSS class `name` from all modules matching `module_name`'
complete -c ironbar -n "__fish_ironbar_using_subcommand help; and __fish_seen_subcommand_from style" -f -a "toggle-class" -d 'Toggle a CSS class `name` on all modules matching `module_name`'
