"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Remove leading indents from a multi-line string.
function stringToHeredoc(value) {
    let addNewline = false;
    const lines = value.split('\n');
    if (lines.length > 0 && lines[0] === '') {
        lines.shift();
    }
    if (lines.length > 0 && lines[lines.length - 1].trim() === '') {
        lines.pop();
        addNewline = true;
    }
    const indents = lines.map((line) => line.search(/[^ ]/)).filter((n) => n >= 0);
    const minIndentLength = Math.min(...indents);
    return lines.map((line) => line.slice(minIndentLength)).join('\n') + (addNewline ? '\n' : '');
}
function renderStringTemplate(strings, ...values) {
    let result = '';
    for (let i = 0; i < strings.length; i++) {
        result += strings[i];
        if (i < values.length) {
            result += `${values[i]}`;
        }
    }
    return result;
}
function heredoc(value, ...values) {
    if (typeof value === 'string') {
        return stringToHeredoc(value);
    }
    else {
        return stringToHeredoc(renderStringTemplate(value, ...values));
    }
}
exports.default = heredoc;
//# sourceMappingURL=index.js.map