"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.urlOpener = void 0;
exports.openUrl = openUrl;
const tslib_1 = require("tslib");
const color_1 = tslib_1.__importDefault(require("@heroku-cli/color"));
const core_1 = require("@oclif/core");
const open_1 = tslib_1.__importDefault(require("open"));
exports.urlOpener = open_1.default;
async function openUrl(url, browser, action) {
    let browserErrorShown = false;
    const showBrowserError = (browser) => {
        if (browserErrorShown)
            return;
        core_1.ux.warn(`Unable to open ${browser ? browser : 'your default'} browser. Visit ${color_1.default.cyan(url)}${action ? ` to ${action}` : ''}.`);
        browserErrorShown = true;
    };
    core_1.ux.log(`Opening ${color_1.default.cyan(url)} in ${browser ? browser : 'your default'} browser… `);
    try {
        await core_1.ux.anykey(`Press any key to open up the browser${action ? ` to ${action}` : ''}, or ${color_1.default.yellow('q')} to exit.`);
    }
    catch (error) {
        const { message, oclif } = error;
        core_1.ux.error(message, { exit: oclif?.exit || 1 });
    }
    const cp = await (0, exports.urlOpener)(url, { wait: false, ...(browser ? { app: { name: browser } } : {}) });
    cp.on('error', (err) => {
        core_1.ux.warn(err);
        showBrowserError(browser);
    });
    cp.on('close', (code) => {
        if (code !== 0)
            showBrowserError(browser);
    });
}
