import { APIClient, Command } from '@heroku-cli/command';
import * as Heroku from '@heroku-cli/schema';
export declare class NotFound extends Error {
    constructor(addonIdentifier: string, appIdentifier?: string);
    readonly statusCode = 404;
    readonly id = "not_found";
}
export declare class AppNotFound extends Error {
    constructor(appIdentifier?: string);
    readonly statusCode = 404;
    readonly id = "not_found";
}
export declare class AmbiguousError extends Error {
    readonly matches: string[];
    constructor(matches: string[], addonIdentifier: string, appIdentifier?: string);
    readonly statusCode = 422;
    readonly id = "multiple_matches";
}
export default abstract class extends Command {
    private _addon?;
    private _addonAttachment?;
    private _addonServiceSlug?;
    private _addonResourceId?;
    private _apiKey?;
    private _apiModelId?;
    private _apiUrl?;
    private _herokuAI?;
    private _defaultInferenceHost;
    protected configureHerokuAIClient(addonIdentifier?: string, appIdentifier?: string): Promise<void>;
    private resolveAddonAndAttachment;
    private handleErrors;
    get addon(): Required<Heroku.AddOn>;
    get addonAttachment(): Required<Heroku.AddOnAttachment>;
    get addonServiceSlug(): string;
    get addonResourceId(): string;
    get apiKey(): string;
    get apiKeyConfigVarName(): string;
    get modelAlias(): string;
    get apiModelId(): string | undefined;
    get apiModelIdConfigVarName(): string;
    get apiUrl(): string;
    get apiUrlConfigVarName(): string;
    get herokuAI(): APIClient;
    get defaultInferenceHost(): string;
}
