import * as Heroku from '@heroku-cli/schema';
export declare const trapConfirmationRequired: <T>(app: string, confirm: string | undefined, fn: (confirmed?: string) => Promise<T>) => Promise<T>;
/**
 * Error handler
 * @param error Error thrown when attempting to create the model resource.
 * @param cmdContext Context of the command that failed.
 * @returns never
 *
 * There's a problem with this error handler implementation, because it relies on the specific error message
 * returned from API in order to format the error correctly. This is prone to fail if changes are introduced
 * upstream on error messages. We should rely on the error `id` but API returns a generic `invalid_params`.
 */
export declare function handlePlatformApiErrors(error: unknown, cmdContext?: {
    as?: string;
    modelName?: string;
}): never;
export declare const formatPrice: ({ price, hourly }: {
    price: Heroku.AddOn["price"] | number;
    hourly?: boolean;
}) => string | undefined;
export declare const formatPriceText: (price: Heroku.AddOn["price"]) => string;
export declare const grandfatheredPrice: (addon: Heroku.AddOn) => any;
export declare const formatState: (state: string) => string;
