import { ReadableStream } from 'node:stream/web';
import type { ChatCompletionResponse } from '@heroku/ai';
export interface StreamOptions {
    onMessage?: (completion: ChatCompletionResponse) => void;
    onError?: (error: Error) => void;
    onDone?: () => void;
}
/**
 * Handles streaming Server-Sent Events (SSE) from the Heroku Inference Agents API.
 * @param stream The incoming message stream from the API response
 * @param options Optional callbacks for handling different stream events
 * @returns Promise that resolves with an array of all completions
 */
export declare function handleAgentStream(stream: ReadableStream<Uint8Array>, options?: StreamOptions): Promise<ChatCompletionResponse[]>;
/**
 * Formats a completion message for display.
 * @param completion The completion response to format
 * @returns Formatted message string or null if no content
 */
export declare function formatCompletionMessage(completion: ChatCompletionResponse): string | null;
