"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const core_1 = require("@oclif/core");
const base_1 = tslib_1.__importDefault(require("../../../lib/base"));
const displayModels = (models) => {
    core_1.ux.log();
    core_1.ux.table(models, {
        model: {
            get: ({ model_id }) => model_id,
        },
        type: {
            get: ({ type }) => type.join(', '),
        },
        supported_regions: {
            get: ({ regions }) => regions.join(', '),
        },
    }, { 'no-header': false });
};
class List extends base_1.default {
    static description = 'list available AI models to provision access to ';
    static examples = [
        '$ heroku ai:models:list',
    ];
    static aliases = ['ai:models'];
    async run() {
        await this.configureHerokuAIClient();
        const herokuAIClient = this.herokuAI;
        const urlPath = '/available-models';
        const { body: availableModels } = await herokuAIClient.get(urlPath);
        displayModels(availableModels);
        core_1.ux.log('\nSee https://devcenter.heroku.com/articles/heroku-inference-api-model-cards for more info. ');
    }
}
exports.default = List;
