"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const color_1 = tslib_1.__importDefault(require("@heroku-cli/color"));
const command_1 = require("@heroku-cli/command");
const core_1 = require("@oclif/core");
const base_1 = tslib_1.__importDefault(require("../../../lib/base"));
const api_client_1 = require("@heroku-cli/command/lib/api-client");
class Detach extends base_1.default {
    static description = 'detach a model resource from an app ';
    static flags = {
        app: command_1.flags.app({ description: 'name of app to detach model resource from', required: true }),
        remote: command_1.flags.remote(),
    };
    static args = {
        model_resource: core_1.Args.string({
            description: 'alias of model resource to detach',
            required: true,
        }),
    };
    static example = 'heroku ai:models:detach EXAMPLE_MODEL_ALIAS --app example-app ';
    async run() {
        const { flags, args } = await this.parse(Detach);
        const { app } = flags;
        const { model_resource: modelResource } = args;
        await this.configureHerokuAIClient(modelResource, app);
        const aiAddon = this.addonAttachment;
        core_1.ux.action.start(`Detaching ${color_1.default.cyan(aiAddon.name || '')} from ${color_1.default.magenta(app)}`);
        await this.heroku.delete(`/addon-attachments/${aiAddon.id}`).catch(error => {
            core_1.ux.action.stop('');
            const error_ = error instanceof api_client_1.HerokuAPIError ? new Error(`We can’t find the model alias ${modelResource}. Check your spelling.`) : error.message;
            core_1.ux.error(error_, { exit: 1 });
        });
        core_1.ux.action.stop();
        core_1.ux.action.start(`Unsetting ${color_1.default.cyan(aiAddon.name || '')} config vars and restarting ${color_1.default.magenta(app)}.`);
        const { body: releases } = await this.heroku.get(`/apps/${app}/releases`, {
            partial: true, headers: { Range: 'version ..; max=1, order=desc' },
        });
        core_1.ux.action.stop(`done, v${releases[0]?.version || ''}`);
    }
}
exports.default = Detach;
