"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@heroku-cli/command");
const base_1 = tslib_1.__importDefault(require("../../../lib/base"));
const core_1 = require("@oclif/core");
class MCP extends base_1.default {
    static description = 'list the MCP server URL';
    static flags = {
        json: command_1.flags.boolean({
            description: 'output in JSON format',
        }),
        app: command_1.flags.app({
            description: 'app to list the MCP server URL for',
            required: false,
        }),
    };
    static args = {
        addon: core_1.Args.string({
            required: false,
            default: 'heroku-inference',
            description: 'unique identifier or globally unique name of add-on',
        }),
    };
    async run() {
        const { flags, args } = await this.parse(MCP);
        // Find the MCP server URL from the billing app's config vars
        await this.configureHerokuAIClient(args.addon, flags.app);
        const { body: config } = await this.heroku.get(`/apps/${this.addon.app?.id}/config-vars`);
        const configVarNames = Object.keys(config);
        const inferenceUrlKeyName = configVarNames.find(key => key.startsWith('INFERENCE_') && key.endsWith('_URL'));
        if (inferenceUrlKeyName) {
            this.log(config[inferenceUrlKeyName] + '/mcp');
        }
        else {
            this.log(`No MCP server URL found for ${flags.app}. Check the Working With MCP On Heroku documentation for setup instructions: https://devcenter.heroku.com/articles/heroku-inference-working-with-mcp`);
        }
    }
}
exports.default = MCP;
