import type { HTTP } from '@heroku/http-call';
import type { APIClient } from '@heroku-cli/command';
import type { ExtendedAddonAttachment } from '../../types/pg/data-api';
/**
 * Cache of app config vars.
 */
export declare const configVarsByAppIdCache: Map<string, Promise<HTTP<Record<string, string>>>>;
/**
 * Returns the app's config vars as a record of key-value pairs, either from the cache or from the API.
 *
 * @param heroku - The Heroku API client
 * @param appId - The ID of the app to get config vars for
 * @returns Promise resolving to a record of config var key-value pairs
 */
export declare function getConfig(heroku: APIClient, appId: string): Promise<Record<string, string>>;
/**
 * Returns the attachment's first config var name that has a `_URL` suffix, expected to be the name of the one
 * that contains the database URL connection string.
 *
 * @param configVarNames - Array of config var names from the attachment
 * @returns The first config var name ending with '_URL'
 * @throws {Error} When no config var names end with '_URL'
 */
export declare function getConfigVarName(configVarNames: ExtendedAddonAttachment['config_vars']): string;
/**
 * Returns the config var name that contains the database URL connection string for the given
 * attachment, based on the contents of the app's config vars.
 *
 * @param attachment - The addon attachment to get the config var name for
 * @param config - Optional record of app config vars (defaults to empty object)
 * @returns The config var name containing the database URL
 * @throws {Error} When no config vars are found or when they don't contain a database URL
 */
export declare function getConfigVarNameFromAttachment(attachment: ExtendedAddonAttachment, config?: Record<string, string>): string;
