"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hux = exports.utils = exports.types = void 0;
const tslib_1 = require("tslib");
const ambiguous_1 = require("./errors/ambiguous");
const not_found_1 = require("./errors/not-found");
const bastion_1 = require("./utils/pg/bastion");
const config_vars_1 = require("./utils/pg/config-vars");
const databases_1 = tslib_1.__importDefault(require("./utils/pg/databases"));
const host_1 = tslib_1.__importDefault(require("./utils/pg/host"));
const psql_1 = tslib_1.__importDefault(require("./utils/pg/psql"));
const confirm_1 = require("./ux/confirm");
const prompt_1 = require("./ux/prompt");
const styled_header_1 = require("./ux/styled-header");
const styled_json_1 = require("./ux/styled-json");
const styled_object_1 = require("./ux/styled-object");
const table_1 = require("./ux/table");
const wait_1 = require("./ux/wait");
// Keep const types for backward compatibility (deprecated)
/** @deprecated Use direct type imports instead */
exports.types = {
    pg: {
        AddOnWithRelatedData: {},
        ConnectionDetails: {},
        ConnectionDetailsWithAttachment: {},
        ExtendedAddonAttachment: {},
        Link: {},
        TunnelConfig: {},
    },
};
exports.utils = {
    errors: {
        AmbiguousError: ambiguous_1.AmbiguousError,
        NotFound: not_found_1.NotFound, // This should be NotFoundError for consistency, but we're keeping it for backwards compatibility
    },
    pg: {
        DatabaseResolver: databases_1.default,
        PsqlService: psql_1.default,
        fetcher: {
            database(heroku, appId, attachmentId, namespace) {
                const databaseResolver = new databases_1.default(heroku);
                return databaseResolver.getDatabase(appId, attachmentId, namespace);
            },
        },
        host: host_1.default,
        psql: {
            exec(connectionDetails, query, psqlCmdArgs = []) {
                const psqlService = new psql_1.default(connectionDetails);
                return psqlService.execQuery(query, psqlCmdArgs);
            },
            getConfigVarNameFromAttachment: config_vars_1.getConfigVarNameFromAttachment,
            getPsqlConfigs: bastion_1.getPsqlConfigs,
            sshTunnel: bastion_1.sshTunnel,
        },
    },
};
exports.hux = {
    confirm: confirm_1.confirm,
    prompt: prompt_1.prompt,
    styledHeader: styled_header_1.styledHeader,
    styledJSON: styled_json_1.styledJSON,
    styledObject: styled_object_1.styledObject,
    table: table_1.table,
    wait: wait_1.wait,
};
