import { APIClient } from '@heroku-cli/command';
import { AmbiguousError } from './errors/ambiguous';
import { NotFound } from './errors/not-found';
import { AddOnWithRelatedData, ExtendedAddonAttachment, Link } from './types/pg/data-api';
import { ConnectionDetails, ConnectionDetailsWithAttachment, TunnelConfig } from './types/pg/tunnel';
import { getPsqlConfigs, sshTunnel } from './utils/pg/bastion';
import { getConfigVarNameFromAttachment } from './utils/pg/config-vars';
import DatabaseResolver from './utils/pg/databases';
import getHost from './utils/pg/host';
import PsqlService from './utils/pg/psql';
import { confirm } from './ux/confirm';
import { prompt } from './ux/prompt';
import { styledHeader } from './ux/styled-header';
import { styledJSON } from './ux/styled-json';
import { styledObject } from './ux/styled-object';
import { table } from './ux/table';
import { wait } from './ux/wait';
export type { AddOnWithRelatedData, ExtendedAddonAttachment, Link, } from './types/pg/data-api';
export type { ConnectionDetails, ConnectionDetailsWithAttachment, TunnelConfig, } from './types/pg/tunnel';
/** @deprecated Use direct type imports instead */
export declare const types: {
    pg: {
        AddOnWithRelatedData: AddOnWithRelatedData;
        ConnectionDetails: ConnectionDetails;
        ConnectionDetailsWithAttachment: ConnectionDetailsWithAttachment;
        ExtendedAddonAttachment: ExtendedAddonAttachment;
        Link: Link;
        TunnelConfig: TunnelConfig;
    };
};
export declare const utils: {
    errors: {
        AmbiguousError: typeof AmbiguousError;
        NotFound: typeof NotFound;
    };
    pg: {
        DatabaseResolver: typeof DatabaseResolver;
        PsqlService: typeof PsqlService;
        fetcher: {
            database(heroku: APIClient, appId: string, attachmentId?: string, namespace?: string): Promise<ConnectionDetailsWithAttachment>;
        };
        host: typeof getHost;
        psql: {
            exec(connectionDetails: ConnectionDetailsWithAttachment, query: string, psqlCmdArgs?: string[]): Promise<string>;
            getConfigVarNameFromAttachment: typeof getConfigVarNameFromAttachment;
            getPsqlConfigs: typeof getPsqlConfigs;
            sshTunnel: typeof sshTunnel;
        };
    };
};
export declare const hux: {
    confirm: typeof confirm;
    prompt: typeof prompt;
    styledHeader: typeof styledHeader;
    styledJSON: typeof styledJSON;
    styledObject: typeof styledObject;
    table: typeof table;
    wait: typeof wait;
};
