"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.vars = exports.Vars = void 0;
const tslib_1 = require("tslib");
const core_1 = require("@oclif/core");
const url = tslib_1.__importStar(require("url"));
const api_client_1 = require("./api-client");
class Vars {
    get host() {
        const { envHost } = this;
        if (envHost && !this.isValidHerokuHost(envHost)) {
            core_1.ux.warn(`Invalid HEROKU_HOST '${envHost}' - using default`);
            return 'heroku.com';
        }
        return envHost || 'heroku.com';
    }
    get apiUrl() {
        return this.host.startsWith('http') ? this.host : `https://api.${this.host}`;
    }
    get apiHost() {
        if (this.host.startsWith('http')) {
            const u = url.parse(this.host);
            if (u.host)
                return u.host;
        }
        return `api.${this.host}`;
    }
    get envHost() {
        return process.env.HEROKU_HOST;
    }
    get envGitHost() {
        return process.env.HEROKU_GIT_HOST;
    }
    get gitHost() {
        if (this.envGitHost)
            return this.envGitHost;
        if (this.host.startsWith('http')) {
            const u = url.parse(this.host);
            if (u.host)
                return u.host;
        }
        return this.host;
    }
    get httpGitHost() {
        if (this.envGitHost)
            return this.envGitHost;
        if (this.host.startsWith('http')) {
            const u = url.parse(this.host);
            if (u.host)
                return u.host;
        }
        return `git.${this.host}`;
    }
    get gitPrefixes() {
        return [`git@${this.gitHost}:`, `ssh://git@${this.gitHost}/`, `https://${this.httpGitHost}/`];
    }
    get envParticleboardUrl() {
        return process.env.HEROKU_PARTICLEBOARD_URL;
    }
    // This should be fixed after we make our staging hostnames consistent throughout all services
    // changing the staging cloud URL to `particleboard.staging.herokudev.com`.
    get particleboardUrl() {
        if (this.envParticleboardUrl)
            return this.envParticleboardUrl;
        return process.env.HEROKU_CLOUD === 'staging' ?
            'https://particleboard-staging-cloud.herokuapp.com' :
            'https://particleboard.heroku.com';
    }
    isValidHerokuHost(host) {
        // Remove protocol if present
        const cleanHost = host.replace(/^https?:\/\//, '');
        return api_client_1.ALLOWED_HEROKU_DOMAINS.some(domain => cleanHost.endsWith(`.${domain}`) || cleanHost === domain) || api_client_1.LOCALHOST_DOMAINS.some(domain => cleanHost.includes(domain));
    }
}
exports.Vars = Vars;
exports.vars = new Vars();
