"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.exists = exists;
exports.readdir = readdir;
exports.readFile = readFile;
const tslib_1 = require("tslib");
const fs = tslib_1.__importStar(require("fs"));
const util_1 = require("util");
let _debug;
function debug(...args) {
    if (_debug)
        _debug = require('debug')('@heroku-cli/command:file');
    _debug(...args);
}
function exists(f) {
    // tslint:disable-next-line
    return (0, util_1.promisify)(fs.exists)(f);
}
function readdir(f) {
    debug('readdir', f);
    return (0, util_1.promisify)(fs.readdir)(f);
}
function readFile(f) {
    debug('readFile', f);
    return (0, util_1.promisify)(fs.readFile)(f);
}
