"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderInfo = exports.displayNat = exports.displayShieldState = void 0;
const core_1 = require("@oclif/core");
const heroku_cli_util_1 = require("@heroku/heroku-cli-util");
const generation_1 = require("../apps/generation");
function displayShieldState(space) {
    return space.shield ? 'on' : 'off';
}
exports.displayShieldState = displayShieldState;
function displayNat(nat) {
    if (!nat)
        return;
    if (nat.state !== 'enabled')
        return nat.state;
    return nat.sources.join(', ');
}
exports.displayNat = displayNat;
function renderInfo(space, json) {
    var _a, _b;
    if (json) {
        core_1.ux.log(JSON.stringify(space, null, 2));
    }
    else {
        heroku_cli_util_1.hux.styledHeader(space.name || '');
        heroku_cli_util_1.hux.styledObject({
            ID: space.id,
            Team: (_a = space.team) === null || _a === void 0 ? void 0 : _a.name,
            Region: (_b = space.region) === null || _b === void 0 ? void 0 : _b.description,
            CIDR: space.cidr,
            'Data CIDR': space.data_cidr,
            State: space.state,
            Shield: displayShieldState(space),
            'Outbound IPs': displayNat(space.outbound_ips),
            Generation: (0, generation_1.getGeneration)(space),
            'Created at': space.created_at,
        }, ['ID', 'Team', 'Region', 'CIDR', 'Data CIDR', 'State', 'Shield', 'Outbound IPs', 'Generation', 'Created at']);
    }
}
exports.renderInfo = renderInfo;
