import { APIClient } from '@heroku-cli/command';
import * as Heroku from '@heroku-cli/schema';
import { App, Pipeline, PipelineCoupling } from './types/fir';
export declare const V3_HEADER = "application/vnd.heroku+json; version=3";
export declare const SDK_HEADER = "application/vnd.heroku+json; version=3.sdk";
export declare const FILTERS_HEADER: string;
export declare const PIPELINES_HEADER: string;
export declare type Owner = Pick<Heroku.Account, 'id' | 'type'> | Pick<Heroku.Team, 'id' | 'type'>;
export declare function createAppSetup(heroku: APIClient, body: {
    body: any;
}): Promise<import("@heroku/http-call").HTTP<Heroku.AppSetup>>;
export declare function postCoupling(heroku: APIClient, pipeline: any, app: any, stage: string): Promise<import("@heroku/http-call").HTTP<unknown>>;
export declare function createCoupling(heroku: APIClient, pipeline: any, app: string, stage: string): Promise<import("@heroku/http-call").HTTP<unknown>>;
export declare function createPipeline(heroku: APIClient, name: string, owner: Owner, generationName?: string): Promise<import("@heroku/http-call").HTTP<Heroku.Pipeline>>;
export declare function createPipelineTransfer(heroku: APIClient, pipeline: Heroku.Pipeline): Promise<import("@heroku/http-call").HTTP<unknown>>;
export declare function destroyPipeline(heroku: APIClient, name: any, pipelineId: any): Promise<import("@heroku/http-call").HTTP<unknown>>;
export declare function findPipelineByName(heroku: APIClient, idOrName: string): Promise<import("@heroku/http-call").HTTP<Heroku.Pipeline[]>>;
export declare function getCoupling(heroku: APIClient, app: string): Promise<import("@heroku/http-call").HTTP<PipelineCoupling>>;
export declare function getPipeline(heroku: APIClient, id: string): Promise<import("@heroku/http-call").HTTP<Pipeline>>;
export declare function updatePipeline(heroku: APIClient, id: string, body: Heroku.Pipeline): Promise<import("@heroku/http-call").HTTP<Heroku.Pipeline>>;
export declare function getTeam(heroku: APIClient, teamId: any): Promise<import("@heroku/http-call").HTTP<Heroku.Team>>;
export declare function getAccountInfo(heroku: APIClient, id?: string): Promise<import("@heroku/http-call").HTTP<Heroku.Account>>;
export declare function getAppSetup(heroku: APIClient, buildId: any): Promise<import("@heroku/http-call").HTTP<Heroku.AppSetup>>;
export interface AppWithPipelineCoupling extends App {
    pipelineCoupling: PipelineCoupling;
    [k: string]: unknown;
}
export declare function listPipelineApps(heroku: APIClient, pipelineId: string): Promise<Array<AppWithPipelineCoupling>>;
export declare function patchCoupling(heroku: APIClient, id: string, stage: string): Promise<import("@heroku/http-call").HTTP<Heroku.PipelineCoupling>>;
export declare function removeCoupling(heroku: APIClient, app: string): Promise<import("@heroku/http-call").HTTP<unknown>>;
export declare function updateCoupling(heroku: APIClient, app: string, stage: string): Promise<import("@heroku/http-call").HTTP<Heroku.PipelineCoupling>>;
export declare function getReleases(heroku: APIClient, appId: string): Promise<import("@heroku/http-call").HTTP<Heroku.Release[]>>;
export declare function getPipelineConfigVars(heroku: APIClient, pipelineID: string): Promise<import("@heroku/http-call").HTTP<Heroku.ConfigVars>>;
export declare function setPipelineConfigVars(heroku: APIClient, pipelineID: string, body: Heroku.ConfigVars | Record<string, null>): Promise<import("@heroku/http-call").HTTP<Heroku.ConfigVars>>;
export declare function createTestRun(heroku: APIClient, body: Heroku.TestRun): Promise<import("@heroku/http-call").HTTP<Heroku.TestRun>>;
export declare function getTestNodes(heroku: APIClient, testRunIdD: string): Promise<import("@heroku/http-call").HTTP<Heroku.TestRun>>;
export declare function updateTestRun(heroku: APIClient, id: string, body: Heroku.TestRun): Promise<import("@heroku/http-call").HTTP<Heroku.TestRun>>;
