"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const command_1 = require("@heroku-cli/command");
const heroku_cli_util_1 = require("@heroku/heroku-cli-util");
const color_1 = require("@heroku-cli/color");
const buildpacks_1 = require("../../lib/buildpacks/buildpacks");
const generation_1 = require("../../lib/apps/generation");
class Index extends command_1.Command {
    async run() {
        const { flags } = await this.parse(Index);
        const buildpacksCommand = new buildpacks_1.BuildpackCommand(this.heroku);
        const { body: app } = await this.heroku.get(`/apps/${flags.app}`, {
            headers: {
                Accept: 'application/vnd.heroku+json; version=3.sdk',
            },
        });
        const isFirApp = (0, generation_1.getGeneration)(app) === 'fir';
        const buildpacks = await buildpacksCommand.fetch(flags.app, isFirApp);
        if (buildpacks.length === 0) {
            this.log(`${color_1.default.app(flags.app)} has no Buildpacks.`);
        }
        else {
            const pluralizedBuildpacks = buildpacks.length > 1 ? 'Buildpacks' : 'Buildpack';
            let header = `${color_1.default.app(flags.app)}`;
            if (isFirApp) {
                header += ` Cloud Native ${pluralizedBuildpacks} (from the latest release's OCI image)`;
            }
            else {
                header += ` Classic ${pluralizedBuildpacks} (from the Heroku Buildpack Registry)`;
            }
            heroku_cli_util_1.hux.styledHeader(header);
            buildpacksCommand.display(buildpacks, '');
        }
    }
}
exports.default = Index;
Index.description = 'list the buildpacks on an app';
Index.flags = {
    app: command_1.flags.app({ required: true }),
    remote: command_1.flags.remote(),
};
