"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const command_1 = require("@heroku-cli/command");
const core_1 = require("@oclif/core");
const heroku_cli_util_1 = require("@heroku/heroku-cli-util");
const util_1 = require("../../lib/addons/util");
const _ = require("lodash");
const printf = require("printf");
class Plans extends command_1.Command {
    printMeteredPricingURL(service) {
        return printf(`https://elements.heroku.com/addons/${service}#pricing`);
    }
    async run() {
        const { flags, args } = await this.parse(Plans);
        const { service } = args;
        let { body: plans } = await this.heroku.get(`/addon-services/${service}/plans`, {
            headers: {
                Accept: 'application/vnd.heroku+json; version=3.sdk',
            },
        });
        plans = _.sortBy(plans, ['price.contract', 'price.cents']);
        if (flags.json) {
            heroku_cli_util_1.hux.styledJSON(plans);
        }
        else {
            heroku_cli_util_1.hux.table(plans, {
                default: {
                    header: '',
                    get: (plan) => plan.default ? 'default' : '',
                },
                name: {
                    header: 'Slug',
                },
                human_name: {
                    header: 'Name',
                },
                price: {
                    header: 'Price',
                    get: (plan) => (0, util_1.formatPrice)({ price: plan.price, hourly: true }),
                },
                max_price: {
                    header: 'Max price',
                    get: (plan) => plan.price.metered ? this.printMeteredPricingURL(service) : (0, util_1.formatPrice)({ price: plan.price, hourly: false }),
                },
            });
        }
    }
}
exports.default = Plans;
Plans.topic = 'addons';
Plans.description = 'list all available plans for an add-on service';
Plans.flags = {
    json: command_1.flags.boolean({ description: 'output in json format' }),
};
Plans.args = {
    service: core_1.Args.string({ required: true, description: 'unique identifier or globally unique name of the add-on' }),
};
