"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AmbiguousError = void 0;
/**
 * This error is used internally to signal when the `AddonAttachmentResolver` cannot resolve
 * to a single attachment.
 */
class AmbiguousError extends Error {
    constructor(matches, type) {
        super();
        this.matches = matches;
        this.type = type;
        this.statusCode = 422;
        this.message = `Ambiguous identifier; multiple matching add-ons found: ${matches.map(match => match.name).join(', ')}.`;
        this.body = { id: 'multiple_matches', message: this.message };
    }
}
exports.AmbiguousError = AmbiguousError;
