import type { ExtendedAddonAttachment } from '../types/pg/data-api';
/**
 * This error is used internally to signal when the `AddonAttachmentResolver` cannot resolve
 * to a single attachment.
 */
export declare class AmbiguousError extends Error {
    readonly matches: ExtendedAddonAttachment[];
    readonly type: string;
    readonly body: {
        id: string;
        message: string;
    };
    readonly message: string;
    readonly statusCode = 422;
    constructor(matches: ExtendedAddonAttachment[], type: string);
}
