"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = confirmCommand;
const tslib_1 = require("tslib");
const color_1 = require("@heroku-cli/color");
const core_1 = require("@oclif/core");
const tsheredoc_1 = tslib_1.__importDefault(require("tsheredoc"));
async function confirmCommand(app, confirm, message) {
    if (confirm) {
        if (confirm === app)
            return;
        throw new Error(`Confirmation ${color_1.color.bold.red(confirm)} did not match ${color_1.color.bold.red(app)}. Aborted.`);
    }
    if (!message) {
        message = (0, tsheredoc_1.default) `
      Destructive Action. 
      This command will affect the app ${color_1.color.bold.red(app)} .
    `;
    }
    core_1.ux.warn(message);
    console.error();
    const entered = await core_1.ux.prompt(`To proceed, type ${color_1.color.bold.red(app)} or re-run this command with ${color_1.color.bold.red('--confirm', app)}.`, { required: true });
    if (entered === app) {
        return;
    }
    throw new Error(`Confirmation did not match ${color_1.color.bold.red(app)}. Aborted.`);
}
