"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = default_1;
const tslib_1 = require("tslib");
const color_1 = tslib_1.__importDefault(require("@heroku-cli/color"));
const core_1 = require("@oclif/core");
const command_1 = require("@heroku-cli/command");
async function default_1(config, addon, force = false) {
    const addonName = addon.name || '';
    const herokuClient = new command_1.APIClient(config);
    core_1.ux.action.start(`Destroying ${color_1.default.addon(addonName)} in background.\nThe app will restart when complete...`);
    await herokuClient.delete(`/apps/${addon.app?.id}/addons/${addon.id}`, {
        headers: { 'Accept-Expansion': 'plan' },
        body: { force },
    }).catch(error => {
        core_1.ux.action.stop('');
        const error_ = error.body && error.body.message ? new Error(`We can't destroy ${color_1.default.addon(addonName)}: ${error.body.message}.`) : new Error(`We can't destroy ${color_1.default.addon(addonName)}: ${error}.`);
        throw error_;
    });
    core_1.ux.action.stop();
}
