"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = default_1;
const tslib_1 = require("tslib");
const core_1 = require("@oclif/core");
const color_1 = tslib_1.__importDefault(require("@heroku-cli/color"));
const util = tslib_1.__importStar(require("./util"));
// eslint-disable-next-line max-params
async function default_1(heroku, app, plan, confirm, options) {
    async function createAddonRequest(confirmed) {
        const body = {
            confirm: confirmed,
            name: options.name,
            config: options.config,
            plan: { name: plan },
            attachment: { name: options.as },
        };
        core_1.ux.action.start(`Creating ${plan} on ${color_1.default.app(app)}`);
        const { body: addon } = await heroku.post(`/apps/${app}/addons`, {
            body,
            headers: {
                'accept-expansion': 'plan',
                'x-heroku-legacy-provider-messages': 'true',
            },
        }).catch(error => {
            core_1.ux.action.stop('');
            throw error;
        });
        // TODO: This is a hack to show 'metered' as the price text.
        // We should rely on the information returned from the API, but here we use a legacy
        // variant for the add-on serialization and only variant '3.sdk' returns metered pricing.
        // ux.action.stop(color.green(util.formatPriceText(addon.plan?.price || '')))
        core_1.ux.action.stop(color_1.default.green('metered'));
        return addon;
    }
    const addon = await util.trapConfirmationRequired(app, confirm, confirm => (createAddonRequest(confirm)));
    if (addon.provision_message) {
        core_1.ux.log(addon.provision_message);
    }
    core_1.ux.log(`Resource name: ${color_1.default.configVar(addon.name)}${options.as ? `\nResource alias: ${color_1.default.configVar(options.as)}` : ''}`);
    core_1.ux.log(`Run ${color_1.default.cmd(`'heroku config -a ${addon.app.name}'`)} to view model config vars associated with this app.`);
    return addon;
}
