"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@heroku-cli/command");
const base_1 = tslib_1.__importDefault(require("../../../lib/base"));
const core_1 = require("@oclif/core");
class List extends base_1.default {
    static description = 'list all available AI tools';
    static flags = {
        json: command_1.flags.boolean({
            description: 'output in JSON format',
        }),
        app: command_1.flags.app({
            description: 'app to list tools for',
            required: false,
        }),
    };
    static args = {
        addon: core_1.Args.string({
            required: false,
            default: 'heroku-inference',
            description: 'unique identifier or globally unique name of add-on',
        }),
    };
    async run() {
        const { flags, args } = await this.parse(List);
        const tools = (await this.getTools(flags.app, args.addon)).filter(Boolean);
        if (flags.json) {
            core_1.ux.styledJSON(tools);
        }
        else if (tools.length === 0) {
            core_1.ux.info('No AI tools are currently available for this app');
        }
        else {
            core_1.ux.table(tools, {
                namespaced_name: { header: 'Tool', get: tool => tool.namespaced_name },
                description: { header: 'Description', get: tool => tool.description },
            });
        }
    }
    async getTools(app, addon) {
        await this.configureHerokuAIClient(addon, app);
        const { body: servers } = await this.herokuAI.get('/v1/mcp/servers');
        return servers.flatMap(server => server.tools);
    }
}
exports.default = List;
