"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const core_1 = require("@oclif/core");
const command_1 = require("@heroku-cli/command");
const destroy_addon_1 = tslib_1.__importDefault(require("../../../lib/ai/models/destroy_addon"));
const confirmCommand_1 = tslib_1.__importDefault(require("../../../lib/confirmCommand"));
const base_1 = tslib_1.__importDefault(require("../../../lib/base"));
class Destroy extends base_1.default {
    static description = 'destroy an existing AI model resource ';
    static flags = {
        app: command_1.flags.app({ required: true, description: 'app to run command against ' }),
        confirm: command_1.flags.string({ char: 'c', description: 'set to app name to bypass confirmation prompt' }),
        force: command_1.flags.boolean({ char: 'f', description: 'allow destruction even if connected to other apps ' }),
        remote: command_1.flags.remote({ description: 'git remote of app to use ' }),
    };
    static args = {
        model_resource: core_1.Args.string({ required: true, description: 'resource ID or alias of model resource to destroy ' }),
    };
    static examples = [
        '$ heroku ai:models:destroy claude-3-5-sonnet-acute-43973 ',
    ];
    async run() {
        const { flags, args } = await this.parse(Destroy);
        const { app, confirm } = flags;
        const { model_resource: modelResource } = args;
        const force = flags.force || process.env.HEROKU_FORCE === '1';
        await this.configureHerokuAIClient(modelResource, app);
        const aiAddon = this.addon;
        await (0, confirmCommand_1.default)(app, confirm);
        await (0, destroy_addon_1.default)(this.config, aiAddon, force);
    }
}
exports.default = Destroy;
