"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const color_1 = tslib_1.__importDefault(require("@heroku-cli/color"));
const command_1 = require("@heroku-cli/command");
const core_1 = require("@oclif/core");
const tsheredoc_1 = tslib_1.__importDefault(require("tsheredoc"));
const create_addon_1 = tslib_1.__importDefault(require("../../../lib/ai/models/create_addon"));
const util_1 = require("../../../lib/ai/models/util");
const base_1 = tslib_1.__importDefault(require("../../../lib/base"));
class Create extends base_1.default {
    static args = {
        model_name: core_1.Args.string({
            description: 'name of AI model to provision access for',
            required: true,
        }),
    };
    static description = 'provision access to an AI model ';
    static example = (0, tsheredoc_1.default) `
    # Provision access to an AI model and attach it to your app with a default name:
    heroku ai:models:create claude-3-5-sonnet --app example-app
    # Provision access to an AI model and attach it to your app with a custom name:
    heroku ai:models:create stable-image-ultra --app example-app --as diffusion 
  `;
    static flags = {
        app: command_1.flags.app({
            description: 'name of app to attach model to',
            required: true,
        }),
        as: command_1.flags.string({ description: 'alias of model resource ' }),
        confirm: command_1.flags.string({ description: 'overwrite existing config vars or existing add-on aliases ' }),
        remote: command_1.flags.remote(),
    };
    async run() {
        const { flags, args } = await this.parse(Create);
        const { app, as, confirm } = flags;
        const { model_name: modelName } = args;
        try {
            const addon = await (0, create_addon_1.default)(this.heroku, app, `${this.addonServiceSlug}:${modelName}`, confirm, { config: {}, as });
            await this.config.runHook('recache', { type: 'addon', app, addon });
            core_1.ux.log(`Use ${color_1.default.cmd('heroku ai:docs')} to view documentation.`);
        }
        catch (error) {
            (0, util_1.handlePlatformApiErrors)(error, { as, modelName });
        }
    }
}
exports.default = Create;
