"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@heroku-cli/command");
const open_url_1 = require("../../lib/open-url");
const base_1 = tslib_1.__importDefault(require("../../lib/base"));
class Docs extends base_1.default {
    static defaultUrl = 'https://devcenter.heroku.com/articles/heroku-inference-cli-commands';
    static description = 'open Heroku Managed Inference and Agent\'s Dev Center documentation in your browser';
    static flags = {
        browser: command_1.flags.string({ description: 'browser to open docs with (example: "firefox", "safari") ' }),
    };
    async run() {
        const { flags } = await this.parse(Docs);
        const browser = flags.browser;
        const url = process.env.HEROKU_AI_DOCS_URL || Docs.defaultUrl;
        await (0, open_url_1.openUrl)(url, browser, 'view the documentation');
    }
}
exports.default = Docs;
