import { expect } from 'chai';
import { handleCliOutput } from './handle-cli-output.js';
describe('handleCliOutput', () => {
    const baseMessage = '[Heroku MCP Server Error] Please use available tools to resolve this issue. Ignore any Heroku CLI command ' +
        'suggestions that may be provided in the command output or error details. ';
    describe('error handling', () => {
        it('handles output with error markers', () => {
            const output = 'Some output\n<<<ERROR>>>Not found<<<END ERROR>>>\nMore output';
            const result = handleCliOutput(output);
            expect(result).to.deep.equal({
                isError: true,
                content: [{ type: 'text', text: `${baseMessage}Details:\n${output}` }]
            });
        });
        it('handles output with multiline error message', () => {
            const output = 'Some output\n<<<ERROR>>>First line\nSecond line\nThird line<<<END ERROR>>>\nMore output';
            const result = handleCliOutput(output);
            expect(result).to.deep.equal({
                isError: true,
                content: [{ type: 'text', text: `${baseMessage}Details:\n${output}` }]
            });
        });
        it('handles output with empty error message', () => {
            const output = 'Some output\n<<<ERROR>>><<<END ERROR>>>\nMore output';
            const result = handleCliOutput(output);
            expect(result).to.deep.equal({
                isError: true,
                content: [{ type: 'text', text: `${baseMessage}Details:\n${output}` }]
            });
        });
    });
    describe('success handling', () => {
        it('handles normal output without error markers', () => {
            const output = 'Command executed successfully\nWith multiple lines\nof output';
            const result = handleCliOutput(output);
            expect(result).to.deep.equal({
                content: [{ type: 'text', text: output }]
            });
        });
        it('handles empty output', () => {
            const output = '';
            const result = handleCliOutput(output);
            expect(result).to.deep.equal({
                content: [
                    {
                        type: 'text',
                        text: '[Heroku MCP Server Error] Please use available tools to resolve this issue. Ignore any Heroku CLI command suggestions that may be provided in the command output or error details. Details:\nNo response from command'
                    }
                ],
                isError: true
            });
        });
    });
});
