/**
 * [Heroku Platform API - Source](https://devcenter.heroku.com/articles/platform-api-reference#source)
 * A source is a location for uploading and downloading an application's source code.
 */
export default class SourceService {
    endpoint;
    /**
     *
     * @param endpoint The endpoint to use for the source service.
     */
    constructor(endpoint) {
        this.endpoint = endpoint;
    }
    /**
     * Create URLs for uploading and downloading source.
     *
     * @param requestInit The initializer for the request.
     * @returns The source.
     */
    async create(requestInit = {}) {
        const response = await fetch(`${this.endpoint}/sources`, {
            ...requestInit,
            method: 'POST',
            headers: {
                ...requestInit?.headers,
                Accept: 'application/vnd.heroku+json; version=3.sdk',
                'Content-Type': 'application/json'
            }
        });
        if (response.ok) {
            return (await response.json());
        }
        let message = response.statusText;
        try {
            ({ message } = (await response.json()));
        }
        catch {
            // no-op
        }
        throw new Error(`${response.status}: ${message}`, { cause: response });
    }
}
