/**
 * [Heroku Platform API - App](https://devcenter.heroku.com/articles/platform-api-reference#app)
 * An app represents the program that you would like to deploy and run on Heroku.
 */
export default class AppService {
    endpoint;
    /**
     *
     * @param endpoint The endpoint to use for the app service.
     */
    constructor(endpoint) {
        this.endpoint = endpoint;
    }
    /**
     * Info for existing app.
     *
     * @param appIdentity unique identifier of app or unique name of app.
     * @param requestInit The initializer for the request.
     * @returns The app.
     */
    async info(appIdentity, requestInit = {}) {
        const response = await fetch(`${this.endpoint}/apps/${appIdentity}`, {
            ...requestInit,
            method: 'GET',
            headers: {
                ...requestInit?.headers,
                Accept: 'application/vnd.heroku+json; version=3.sdk'
            }
        });
        if (response.ok) {
            return (await response.json());
        }
        let message = response.statusText;
        try {
            ({ message } = (await response.json()));
        }
        catch {
            // no-op
        }
        throw new Error(`${response.status}: ${message}`, { cause: response });
    }
}
