# halConfig.cmake
# --------------------
#
# HAL cmake module.
# This module sets the following variables in your project::
#
#   hal_FOUND - true if hal and all required components found on the system
#   hal_VERSION - hal version in format Major.Minor.Release
#   hal_INCLUDE_DIR - Directory where hal headers are located.
#   CMAKE_MODULE_PATH - appends location of accompanying FindFilesystem.cmake and
#                       hal_cmake_tools.cmake modules.
#
#
# Available components: None
#
#
# Exported targets::
#
# If hal is found, this module defines the following :prop_tgt:`IMPORTED`
# interface library targets::
#
#   hal::core -
#   hal::netlist -



####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was halConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(PN hal)

set(${PN}_VERSION 4.5.0)

set_and_check(${PN}_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")

set(${PN}_LIBRARY "")
set(${PN}_DEFINITIONS USING_${PN})

check_required_components(${PN})

list(APPEND CMAKE_MODULE_PATH ${CMAKE_CURRENT_LIST_DIR})

include(hal_plugin)

find_package(Filesystem REQUIRED Final Experimental)

add_subdirectory(${CMAKE_CURRENT_LIST_DIR}/pybind11 ${CMAKE_BINARY_DIR}/deps/pybind11)

set(spdlog_VERSION 1.9.2)
        add_library(spdlog::spdlog INTERFACE IMPORTED)
        set_target_properties(spdlog::spdlog PROPERTIES
                            INTERFACE_INCLUDE_DIRECTORIES "${CMAKE_CURRENT_LIST_DIR}/spdlog-${spdlog_VERSION}/include"
                            )
set_and_check(${PN}_GENVERSION_PATH "${CMAKE_CURRENT_LIST_DIR}")
if(NOT (CMAKE_VERSION VERSION_LESS 3.0))
#-----------------------------------------------------------------------------
# Don't include targets if this file is being picked up by another
# project which has already built this as a subproject
#-----------------------------------------------------------------------------
    if(NOT TARGET ${PN}::core)
        include("${CMAKE_CURRENT_LIST_DIR}/${PN}Targets.cmake")
    endif()
endif()

set(${PN}_FOUND true)
