/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.DecodeSequenceMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.JsonIteratorArrayWrapped;
import kotlinx.serialization.json.internal.JsonIteratorWsSeparated;
import kotlinx.serialization.json.internal.ReaderJsonLexer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a:\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\nH\u0000\u001a\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"JsonIterator", "", "T", "mode", "Lkotlinx/serialization/json/DecodeSequenceMode;", "json", "Lkotlinx/serialization/json/Json;", "lexer", "Lkotlinx/serialization/json/internal/ReaderJsonLexer;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "determineFormat", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "suggested", "tryConsumeStartArray", "", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nJsonIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonIterator.kt\nkotlinx/serialization/json/internal/JsonIteratorKt\n+ 2 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer\n+ 3 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer$fail$1\n*L\n1#1,103:1\n226#2,10:104\n229#3:114\n*S KotlinDebug\n*F\n+ 1 JsonIterator.kt\nkotlinx/serialization/json/internal/JsonIteratorKt\n*L\n39#1:104,10\n39#1:114\n*E\n"})
public final class JsonIteratorKt {
    @NotNull
    public static final <T> Iterator<T> JsonIterator(@NotNull DecodeSequenceMode mode, @NotNull Json json, @NotNull ReaderJsonLexer lexer, @NotNull DeserializationStrategy<? extends T> deserializer) {
        Iterator iterator2;
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(lexer, "lexer");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        switch (WhenMappings.$EnumSwitchMapping$0[JsonIteratorKt.determineFormat(lexer, mode).ordinal()]) {
            case 1: {
                iterator2 = new JsonIteratorWsSeparated<T>(json, lexer, deserializer);
                break;
            }
            case 2: {
                iterator2 = new JsonIteratorArrayWrapped<T>(json, lexer, deserializer);
                break;
            }
            case 3: {
                throw new IllegalStateException("AbstractJsonLexer.determineFormat must be called beforehand.".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return iterator2;
    }

    /*
     * WARNING - void declaration
     */
    private static final DecodeSequenceMode determineFormat(AbstractJsonLexer $this$determineFormat, DecodeSequenceMode suggested) {
        DecodeSequenceMode decodeSequenceMode;
        switch (WhenMappings.$EnumSwitchMapping$0[suggested.ordinal()]) {
            case 1: {
                decodeSequenceMode = DecodeSequenceMode.WHITESPACE_SEPARATED;
                break;
            }
            case 2: {
                void source;
                String s$iv;
                if (JsonIteratorKt.tryConsumeStartArray($this$determineFormat)) {
                    decodeSequenceMode = DecodeSequenceMode.ARRAY_WRAPPED;
                    break;
                }
                byte expectedToken$iv = 8;
                boolean wasConsumed$iv = true;
                boolean $i$f$fail$kotlinx_serialization_json = false;
                String expected$iv = AbstractJsonLexerKt.tokenDescription(expectedToken$iv);
                int position$iv = $this$determineFormat.currentPosition - 1;
                String string = s$iv = $this$determineFormat.currentPosition == AbstractJsonLexer.access$getSource($this$determineFormat).length() || position$iv < 0 ? "EOF" : String.valueOf(AbstractJsonLexer.access$getSource($this$determineFormat).charAt(position$iv));
                String string2 = expected$iv;
                AbstractJsonLexer abstractJsonLexer = $this$determineFormat;
                boolean bl = false;
                String expected = string2;
                AbstractJsonLexer.fail$default(abstractJsonLexer, "Expected " + expected + ", but had '" + (String)source + "' instead", position$iv, null, 4, null);
                throw new KotlinNothingValueException();
            }
            case 3: {
                if (JsonIteratorKt.tryConsumeStartArray($this$determineFormat)) {
                    decodeSequenceMode = DecodeSequenceMode.ARRAY_WRAPPED;
                    break;
                }
                decodeSequenceMode = DecodeSequenceMode.WHITESPACE_SEPARATED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return decodeSequenceMode;
    }

    private static final boolean tryConsumeStartArray(AbstractJsonLexer $this$tryConsumeStartArray) {
        if ($this$tryConsumeStartArray.peekNextToken() == 8) {
            $this$tryConsumeStartArray.consumeNextToken((byte)8);
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DecodeSequenceMode.values().length];
            try {
                nArray[DecodeSequenceMode.WHITESPACE_SEPARATED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DecodeSequenceMode.ARRAY_WRAPPED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DecodeSequenceMode.AUTO_DETECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

