/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.quickfix;

import com.goide.psi.GoBlock;
import com.goide.psi.GoElseStatement;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.impl.GoElementFactory;
import com.goide.quickfix.GoSimplifyIfStatementUtil;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.go.linter.GoLinterBundle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J3\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0096\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/go/linter/quickfix/GoOutdentElseFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/goide/psi/GoStatement;", "<init>", "(Lcom/goide/psi/GoStatement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nGoOutdentElseFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoOutdentElseFix.kt\ncom/intellij/go/linter/quickfix/GoOutdentElseFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1869#2,2:60\n*S KotlinDebug\n*F\n+ 1 GoOutdentElseFix.kt\ncom/intellij/go/linter/quickfix/GoOutdentElseFix\n*L\n49#1:60,2\n*E\n"})
public final class GoOutdentElseFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public GoOutdentElseFix(@NotNull GoStatement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return GoLinterBundle.message("intention.name.outdent.else.branch", new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        GoElseStatement goElseStatement;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        PsiElement psiElement = startElement;
        if (psiElement instanceof GoIfStatement) {
            GoStatement initStatement = ((GoIfStatement)startElement).getInitStatement();
            if (initStatement != null) {
                ((GoIfStatement)startElement).getParent().addBefore(initStatement.copy(), startElement);
            }
            GoStatement goStatement = ((GoIfStatement)startElement).getInitStatement();
            if (goStatement != null) {
                goStatement.delete();
            }
            PsiElement psiElement2 = ((GoIfStatement)startElement).getSemicolon();
            if (psiElement2 != null) {
                psiElement2.delete();
            }
            GoElseStatement goElseStatement2 = ((GoIfStatement)startElement).getElseStatement();
            goElseStatement = goElseStatement2;
            Intrinsics.checkNotNull((Object)goElseStatement2);
        } else if (psiElement instanceof GoElseStatement) {
            goElseStatement = (GoElseStatement)startElement;
        } else {
            return;
        }
        GoElseStatement elseStatement = goElseStatement;
        PsiElement parent = elseStatement.getParent();
        if (elseStatement.getBlock() == null || parent == null) {
            return;
        }
        GoRefactoringUtil.withVerticalScrollingSaved((Editor)editor, () -> GoOutdentElseFix.invoke$lambda$3(parent, project, elseStatement, editor));
    }

    private static final boolean invoke$lambda$3$lambda$0(SmartList $results, PsiElement $parent, GoElseStatement $elseStatement, PsiElement it) {
        return $results.add((Object)$parent.addBefore(it, (PsiElement)$elseStatement));
    }

    private static final boolean invoke$lambda$3$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void invoke$lambda$3(PsiElement $parent, Project $project, GoElseStatement $elseStatement, Editor $editor) {
        SmartList results = new SmartList((Object)$parent.addBefore(GoElementFactory.createNewLine((Project)$project), (PsiElement)$elseStatement));
        GoBlock goBlock = $elseStatement.getBlock();
        Intrinsics.checkNotNull((Object)goBlock);
        GoSimplifyIfStatementUtil.processElementsWithComments((List)goBlock.getStatementList(), arg_0 -> GoOutdentElseFix.invoke$lambda$3$lambda$1(arg_0 -> GoOutdentElseFix.invoke$lambda$3$lambda$0(results, $parent, $elseStatement, arg_0), arg_0));
        Iterable $this$forEach$iv = (Iterable)results;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            CodeEditUtil.markToReformat((ASTNode)it.getNode(), (boolean)true);
        }
        $elseStatement.delete();
        PsiElement firstResult = (PsiElement)ContainerUtil.getFirstItem((List)((List)results));
        if ($editor != null && firstResult != null) {
            $editor.getCaretModel().moveToOffset(firstResult.getTextRange().getStartOffset());
        }
        GoRefactoringUtil.highlightSearchResults((Project)$project, (Editor)$editor, (List)((List)results));
    }
}

