/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.quickfix;

import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoTypeSwitchGuard;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarSpec;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.go.linter.GoLinterBundle;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.SearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J3\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0096\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/go/linter/quickfix/GoDeleteVarDefinitionFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/goide/psi/GoVarDefinition;", "<init>", "(Lcom/goide/psi/GoVarDefinition;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nGoDeleteVarDefinitionFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDeleteVarDefinitionFix.kt\ncom/intellij/go/linter/quickfix/GoDeleteVarDefinitionFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1869#2,2:65\n*S KotlinDebug\n*F\n+ 1 GoDeleteVarDefinitionFix.kt\ncom/intellij/go/linter/quickfix/GoDeleteVarDefinitionFix\n*L\n22#1:65,2\n*E\n"})
public final class GoDeleteVarDefinitionFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public GoDeleteVarDefinitionFix(@NotNull GoVarDefinition element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public String getFamilyName() {
        return GoLinterBundle.message("intention.family.name.delete.variable", new Object[0]);
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[1];
        PsiElement psiElement = this.getStartElement();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.goide.psi.GoVarDefinition");
        Intrinsics.checkNotNull((Object)((GoVarDefinition)psiElement).getName());
        return GoLinterBundle.message("intention.name.delete.variable", objectArray);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        GoVarDefinition element = (GoVarDefinition)startElement;
        if (element.isValid()) {
            Iterable $this$forEach$iv = GoReferencesSearch.search((PsiElement)((PsiElement)element), (SearchScope)element.getUseScope()).asIterable();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement usage;
                PsiReference reference = (PsiReference)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)reference.getElement(), (String)"getElement(...)");
                PsiElement parent = usage.getParent();
                if (usage instanceof GoVarDefinition) {
                    Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type com.goide.psi.GoVarSpec");
                    ((GoVarSpec)parent).deleteDefinition((GoVarOrConstDefinition)usage);
                    continue;
                }
                if (!(usage instanceof GoReferenceExpression)) continue;
                if (parent instanceof GoLeftHandExprList) {
                    GoAssignmentStatement assignment;
                    PsiElement psiElement = ((GoLeftHandExprList)parent).getParent();
                    GoAssignmentStatement goAssignmentStatement = assignment = psiElement instanceof GoAssignmentStatement ? (GoAssignmentStatement)psiElement : null;
                    if (assignment != null && assignment.deleteExpression((GoExpression)usage)) {
                        return;
                    }
                }
                reference.handleElementRename("_");
            }
            PsiElement parent = element.getParent();
            if (parent instanceof GoVarSpec) {
                ((GoVarSpec)parent).deleteDefinition((GoVarOrConstDefinition)element);
            } else {
                PsiElement varAssign;
                if (parent instanceof GoTypeSwitchGuard && (varAssign = ((GoTypeSwitchGuard)parent).getVarAssign()) != null) {
                    PsiElement lastElement = varAssign;
                    while (lastElement.getNextSibling() instanceof PsiWhiteSpace) {
                        Intrinsics.checkNotNullExpressionValue((Object)lastElement.getNextSibling(), (String)"getNextSibling(...)");
                    }
                    ((GoTypeSwitchGuard)parent).deleteChildRange((PsiElement)element, lastElement);
                    return;
                }
                Attachment[] attachmentArray = new Attachment[]{AttachmentFactory.createAttachment((VirtualFile)parent.getContainingFile().getVirtualFile())};
                LocalQuickFixAndIntentionActionOnPsiElement.LOG.error("Cannot delete variable " + element.getName() + ". Parent: " + parent.getClass().getSimpleName(), attachmentArray);
            }
        }
    }
}

