/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.platform;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.go.linter.platform.Linux;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/go/linter/platform/WSL;", "Lcom/intellij/go/linter/platform/Linux;", "project", "Lcom/intellij/openapi/project/Project;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/wsl/WSLDistribution;)V", "tempPath", "", "defaultPath", "Ljava/nio/file/Path;", "isWSLAvailablePath", "", "path", "canExecute", "canWrite", "fetchLatestGoLinter", "Lkotlin/Pair;", "destDir", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.go.linter"})
public final class WSL
extends Linux {
    @NotNull
    private final WSLDistribution distribution;

    public WSL(@NotNull Project project, @NotNull WSLDistribution distribution) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        super(project);
        this.distribution = distribution;
    }

    @Override
    @NotNull
    protected String tempPath() {
        String string = System.getenv("TEMP");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
        return string;
    }

    @Override
    @NotNull
    public Path defaultPath() {
        String string = this.distribution.getWindowsPath(((Object)super.defaultPath()).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWindowsPath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    private final boolean isWSLAvailablePath(Path path) {
        WSLDistribution wSLDistribution = WslPath.Companion.getDistributionByWindowsUncPath(((Object)path).toString());
        return wSLDistribution != null ? wSLDistribution.equals((Object)this.distribution) : true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canExecute(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!this.isWSLAvailablePath(path)) return false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        return true;
    }

    @Override
    public boolean canWrite(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.isWSLAvailablePath(path);
    }

    @Override
    @NotNull
    public Pair<Path, String> fetchLatestGoLinter(@NotNull Path destDir, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        WSLDistribution wSLDistribution = WslPath.Companion.getDistributionByWindowsUncPath(((Object)destDir).toString());
        if (wSLDistribution == null) {
            return super.fetchLatestGoLinter(destDir, progressIndicator);
        }
        WSLDistribution d = wSLDistribution;
        if (!Intrinsics.areEqual((Object)d, (Object)this.distribution)) {
            throw new Exception("cannot download to a different WSL distribution " + d.getMsId() + " other than " + this.distribution.getMsId());
        }
        progressIndicator.setText("Copy into WSL");
        String tempDir = System.getenv("TEMP");
        Intrinsics.checkNotNull((Object)tempDir);
        Path path = Paths.get(tempDir, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Pair<Path, String> pair = super.fetchLatestGoLinter(path, progressIndicator);
        Path binary = (Path)pair.component1();
        String version2 = (String)pair.component2();
        String string = this.distribution.getWslPath(destDir);
        Intrinsics.checkNotNull((Object)string);
        String wslPath = string + "/" + this.linterName();
        Object[] objectArray = new String[]{"cp", this.distribution.getWslPath(binary), wslPath};
        ProcessOutput processOutput = this.distribution.executeOnWsl(CollectionsKt.listOf((Object[])objectArray), new WSLCommandLineOptions(), 2000, null);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"executeOnWsl(...)");
        ProcessOutput cp = processOutput;
        if (cp.getExitCode() != 0) {
            throw new Exception("Failed to copy " + binary + " into WSL " + wslPath + ": " + cp.getStderr());
        }
        String string2 = this.distribution.getWindowsPath(wslPath);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getWindowsPath(...)");
        Path path2 = Paths.get(string2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return TuplesKt.to((Object)path2, (Object)version2);
    }
}

