/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.platform;

import com.goide.sdk.GoSdkService;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.go.linter.GoLinterBundle;
import com.intellij.go.linter.UtilitiesKt;
import com.intellij.go.linter.model.GithubAsset;
import com.intellij.go.linter.model.GithubRelease;
import com.intellij.go.linter.platform.Linux;
import com.intellij.go.linter.platform.Mac;
import com.intellij.go.linter.platform.Platform;
import com.intellij.go.linter.platform.PlatformKt;
import com.intellij.go.linter.platform.WSL;
import com.intellij.go.linter.platform.Windows;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.DownloadUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&J\b\u0010\u000b\u001a\u00020\tH$J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H$J\b\u0010\u0014\u001a\u00020\tH&J\b\u0010\u0015\u001a\u00020\u0016H&J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\t0\u001c2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u001fH\u0086@\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u0004\u0018\u00010\u0016H\u0086@\u00a2\u0006\u0002\u0010 J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006&"}, d2={"Lcom/intellij/go/linter/platform/Platform;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDownloadArchiveName", "", "version", "tempPath", "decompress", "", "archive", "Ljava/io/File;", "targetDir", "fileName", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "linterName", "defaultPath", "Ljava/nio/file/Path;", "canExecute", "", "path", "canWrite", "fetchLatestGoLinter", "Lkotlin/Pair;", "destDir", "findInstalledLinterExecutables", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDefaultExecutable", "adjustLinterExeChooser", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "initial", "Companion", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Platform.kt\ncom/intellij/go/linter/platform/Platform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n626#2,12:265\n1563#2:278\n1634#2,3:279\n774#2:282\n865#2,2:283\n1#3:277\n*S KotlinDebug\n*F\n+ 1 Platform.kt\ncom/intellij/go/linter/platform/Platform\n*L\n93#1:265,12\n118#1:278\n118#1:279,3\n119#1:282\n119#1:283,2\n*E\n"})
public abstract class Platform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    public static final String LinterName = "golangci-lint";

    public Platform(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public abstract String getDownloadArchiveName(@NotNull String var1);

    @NotNull
    protected abstract String tempPath();

    protected abstract void decompress(@NotNull File var1, @NotNull File var2, @NotNull String var3, @NotNull ProgressIndicator var4);

    @NotNull
    public abstract String linterName();

    @NotNull
    public abstract Path defaultPath();

    public boolean canExecute(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path.toFile().canExecute();
    }

    public boolean canWrite(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path.toFile().canWrite();
    }

    @NotNull
    public Pair<Path, String> fetchLatestGoLinter(@NotNull Path destDir, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Path executable = destDir.resolve(this.linterName());
        Intrinsics.checkNotNull((Object)executable);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(executable, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new RuntimeException("File already exists: " + executable);
        }
        progressIndicator.setText(GoLinterBundle.message("download.progress.title.getting.metadata", new Object[0]));
        GithubRelease latest = UtilitiesKt.getLatestReleaseMeta$default(null, 1, null);
        progressIndicator.setFraction(0.2);
        progressIndicator.checkCanceled();
        String version2 = StringsKt.removePrefix((String)latest.getName(), (CharSequence)"v");
        String binaryFileName = this.getDownloadArchiveName(version2);
        Iterable $this$single$iv = latest.getAssets();
        boolean $i$f$single22 = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            GithubAsset it = (GithubAsset)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)binaryFileName)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        GithubAsset asset = single$iv;
        Object[] $i$f$single22 = new String[]{binaryFileName};
        File tmp = Paths.get(this.tempPath(), (String[])$i$f$single22).toFile();
        $i$f$single22 = new Object[]{binaryFileName};
        progressIndicator.setText(GoLinterBundle.message("download.progress.title.downloading", $i$f$single22));
        DownloadUtil.downloadContentToFile((ProgressIndicator)progressIndicator, (String)asset.getBrowserDownloadUrl(), (File)tmp);
        File targetDir = destDir.toFile();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)targetDir);
        objectArray[0] = targetDir;
        progressIndicator.setText(GoLinterBundle.message("download.progress.title.decompressing", objectArray));
        Intrinsics.checkNotNull((Object)tmp);
        this.decompress(tmp, targetDir, this.linterName(), progressIndicator);
        tmp.delete();
        File it = executable.toFile();
        boolean bl = false;
        boolean bl2 = !it.canExecute() && !it.setExecutable(true);
        if (bl2) {
            throw new Exception("Permission denied to execute " + targetDir);
        }
        return TuplesKt.to((Object)executable, (Object)version2);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object findInstalledLinterExecutables(@NotNull Continuation<? super Iterable<? extends Path>> $completion) {
        if (!($completion instanceof findInstalledLinterExecutables.1)) ** GOTO lbl-1000
        var14_2 = $completion;
        if ((var14_2.label & -2147483648) != 0) {
            var14_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ Platform this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.findInstalledLinterExecutables((Continuation<? super Iterable<? extends Path>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$findInstalledLinterExecutables_u24lambda_u242 = var3_5 = CollectionsKt.createListBuilder();
                $i$a$-buildList-Platform$findInstalledLinterExecutables$paths$1 = 0;
                $this$findInstalledLinterExecutables_u24lambda_u242.add(this.defaultPath());
                var6_10 = $this$findInstalledLinterExecutables_u24lambda_u242;
                $continuation.L$0 = var3_5;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$findInstalledLinterExecutables_u24lambda_u242);
                $continuation.L$2 = var6_10;
                $continuation.I$0 = $i$a$-buildList-Platform$findInstalledLinterExecutables$paths$1;
                $continuation.label = 1;
                v0 = PlatformKt.getPathList(this.project, (Continuation<? super List<? extends Path>>)$continuation);
                if (v0 == var15_4) {
                    return var15_4;
                }
                ** GOTO lbl33
            }
            case 1: {
                $i$a$-buildList-Platform$findInstalledLinterExecutables$paths$1 = $continuation.I$0;
                var6_10 = (List)$continuation.L$2;
                $this$findInstalledLinterExecutables_u24lambda_u242 = (List)$continuation.L$1;
                var3_5 = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                var6_10.addAll((Collection)v0);
                paths = CollectionsKt.build((List)var3_5);
                $this$map$iv = paths;
                $i$f$map = false;
                $i$a$-buildList-Platform$findInstalledLinterExecutables$paths$1 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var10_15 = (Path)item$iv$iv;
                    var12_17 = destination$iv$iv;
                    $i$a$-map-Platform$findInstalledLinterExecutables$2 = false;
                    var12_17.add(it.resolve(this.linterName()));
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Path)element$iv$iv;
                    $i$a$-filter-Platform$findInstalledLinterExecutables$3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.canExecute(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getDefaultExecutable(@NotNull Continuation<? super Path> $completion) {
        if (!($completion instanceof getDefaultExecutable.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ Platform this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getDefaultExecutable((Continuation<? super Path>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.findInstalledLinterExecutables((Continuation<? super Iterable<? extends Path>>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                return CollectionsKt.firstOrNull((Iterable)((Iterable)v0));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public FileChooserDescriptor adjustLinterExeChooser(@NotNull FileChooserDescriptor initial) {
        FileChooserDescriptor fileChooserDescriptor;
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        FileChooserDescriptor it = fileChooserDescriptor = initial;
        boolean bl = false;
        it.withFileFilter(arg_0 -> Platform.adjustLinterExeChooser$lambda$7$lambda$6(arg_0 -> Platform.adjustLinterExeChooser$lambda$7$lambda$5(this, arg_0), arg_0));
        return fileChooserDescriptor;
    }

    private static final boolean adjustLinterExeChooser$lambda$7$lambda$5(Platform this$0, VirtualFile vf) {
        Path path = vf.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        return this$0.canExecute(path);
    }

    private static final boolean adjustLinterExeChooser$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/go/linter/platform/Platform$Companion;", "", "<init>", "()V", "platformFactory", "Lcom/intellij/go/linter/platform/Platform;", "project", "Lcom/intellij/openapi/project/Project;", "LinterName", "", "intellij.go.linter"})
    @SourceDebugExtension(value={"SMAP\nPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Platform.kt\ncom/intellij/go/linter/platform/Platform$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n1#2:265\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final Platform platformFactory(@NotNull Project project) {
            Platform platform;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (SystemInfo.isWindows) {
                String string;
                VirtualFile virtualFile = GoSdkService.getInstance((Project)project).getSdk(null).getSdkRoot();
                if (virtualFile != null && (string = virtualFile.getPath()) != null) {
                    String string2 = string;
                    WslPath.Companion companion = WslPath.Companion;
                    String p0 = string2;
                    boolean bl = false;
                    WSLDistribution wSLDistribution = companion.getDistributionByWindowsUncPath(p0);
                    if (wSLDistribution != null) {
                        WSLDistribution it = wSLDistribution;
                        boolean bl2 = false;
                        platform = new WSL(project, it);
                        return platform;
                    }
                }
                platform = new Windows(project);
                return platform;
            }
            if (SystemInfo.isLinux) {
                platform = new Linux(project);
                return platform;
            }
            if (!SystemInfo.isMac) throw new Exception("Unknown system type: " + SystemInfo.OS_NAME);
            platform = new Mac(project);
            return platform;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

