/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.form;

import com.intellij.ui.components.JBCheckBox;
import java.awt.Component;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

class CheckBoxCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private final transient ItemListener listener;
    private final JCheckBox checkBox = new JBCheckBox();

    CheckBoxCellEditor(ItemListener listener) {
        this.listener = listener;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JBCheckBox cb = new JBCheckBox(null, ((Boolean)value).booleanValue());
        if (isSelected) {
            cb.setForeground(table.getSelectionForeground());
            cb.setBackground(table.getSelectionBackground());
        } else {
            cb.setForeground(table.getForeground());
            cb.setBackground(table.getBackground());
        }
        return cb;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.checkBox.removeItemListener(this.listener);
        this.checkBox.setSelected((Boolean)value);
        this.checkBox.setForeground(table.getSelectionForeground());
        this.checkBox.setBackground(table.getSelectionBackground());
        this.checkBox.addItemListener(this.listener);
        return this.checkBox;
    }

    @Override
    public Object getCellEditorValue() {
        return this.checkBox.isSelected();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return anEvent instanceof MouseEvent;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }
}

