/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.MutableNameAndValue;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J.\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_12;", "Lcom/intellij/database/model/serialization/Converter;", "<init>", "()V", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "deduceDbms", "oldProp", "", "convert", "Lkotlin/Function1;", "Lcom/intellij/database/Dbms;", "intellij.database.core.impl"})
public final class Converter_4_12
extends Converter {
    @NotNull
    public static final Converter_4_12 INSTANCE = new Converter_4_12();

    private Converter_4_12() {
        int[] nArray = new int[]{4, 12};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        Dbms dbms = modelMem.getDbms();
        if (Intrinsics.areEqual((Object)dbms, (Object)Dbms.MSSQL)) {
            this.deduceDbms(modelMem, "ServerType", (Function1<? super String, Dbms>)((Function1)Converter_4_12::convertMem$lambda$0));
        } else if (Intrinsics.areEqual((Object)dbms, (Object)Dbms.MYSQL)) {
            this.deduceDbms(modelMem, "RdbmsFlavour", (Function1<? super String, Dbms>)((Function1)Converter_4_12::convertMem$lambda$1));
        }
    }

    private final void deduceDbms(ModelMem modelMem, String oldProp, Function1<? super String, Dbms> convert) {
        for (ModelElementMem node : modelMem.getNodes()) {
            if (!Intrinsics.areEqual((Object)node.getKind(), (Object)"root")) continue;
            Iterator<MutableNameAndValue> it = node.getProperties().iterator();
            Dbms dbms = null;
            while (it.hasNext()) {
                MutableNameAndValue prop = it.next();
                if (!Intrinsics.areEqual((Object)prop.getName(), (Object)oldProp)) continue;
                dbms = (Dbms)convert.invoke((Object)prop.getValue());
                it.remove();
            }
            node.getProperties().removeIf(arg_0 -> Converter_4_12.deduceDbms$lambda$3(Converter_4_12::deduceDbms$lambda$2, arg_0));
            if (dbms == null) continue;
            List<MutableNameAndValue> list = node.getProperties();
            String string = PropertyConverter.export(dbms);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"export(...)");
            list.add(new MutableNameAndValue("FamilyId", string));
        }
    }

    private static final Dbms convertMem$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)"azure") ? Dbms.AZURE : null;
    }

    private static final Dbms convertMem$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it;
        return Intrinsics.areEqual((Object)string, (Object)"MemSQL") ? Dbms.MEMSQL : (Intrinsics.areEqual((Object)string, (Object)"MariaDB") ? Dbms.MARIA : null);
    }

    private static final boolean deduceDbms$lambda$2(MutableNameAndValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)"FamilyId");
    }

    private static final boolean deduceDbms$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

