/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysql.plan;

import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.mysql.plan.MysqlTreeRawPlanData;
import com.intellij.database.plan.PlanModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlTreePlanModelBuilder
extends AbstractPlanModelBuilder<MysqlTreeRawPlanData, Integer> {
    public static final Map<String, PlanModel.NodeType> TYPE_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private final Pattern RAW = Pattern.compile("^\\s*->(.*?)(?::| #| \\(|$)");
    private final Pattern NODE_TYPE = Pattern.compile("^\\s*->(.*?)(?: on|:| #| \\(|$)");
    private final Pattern RELATION = Pattern.compile(" on (.*?)(?: using| \\(|$)");
    private final Pattern INDEX = Pattern.compile(" using (.*?)(?: \\(|$)");

    protected MysqlTreePlanModelBuilder() {
        super(EnumSet.noneOf(PlanModel.Feature.class));
    }

    @Override
    @NotNull
    public MysqlTreeRawPlanData createData() {
        return new MysqlTreeRawPlanData();
    }

    @Override
    protected void parseData() {
        this.myActual = false;
        this.openNode(null);
        this.openNode(null);
        if (!((MysqlTreeRawPlanData)this.myData).rows.isEmpty()) {
            this.parseSubPlans(((MysqlTreeRawPlanData)this.myData).indents.get(0), 0);
        }
        this.closeNode(this.createNode(null, PlanModel.NodeType.SELECT, null));
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull Integer line) {
        String row;
        Matcher matcher;
        if (line == null) {
            MysqlTreePlanModelBuilder.$$$reportNull$$$0(0);
        }
        if (!(matcher = this.RAW.matcher(row = ((MysqlTreeRawPlanData)this.myData).rows.get(line))).find()) {
            String string = row;
            if (string == null) {
                MysqlTreePlanModelBuilder.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = StringUtil.trimStart((String)row.substring(matcher.end(1)).replaceAll("\\((cost|actual)[^)]+\\)", ""), (String)":").trim();
        if (string == null) {
            MysqlTreePlanModelBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull Integer line) {
        Matcher matcher;
        if (line == null) {
            MysqlTreePlanModelBuilder.$$$reportNull$$$0(3);
        }
        return (matcher = this.RELATION.matcher(((MysqlTreeRawPlanData)this.myData).rows.get(line))).find() ? matcher.group(1).trim() : null;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull Integer line) {
        Matcher matcher;
        if (line == null) {
            MysqlTreePlanModelBuilder.$$$reportNull$$$0(4);
        }
        return (matcher = this.INDEX.matcher(((MysqlTreeRawPlanData)this.myData).rows.get(line))).find() ? matcher.group(1).trim() : null;
    }

    @Override
    protected void parsePlan(@NotNull Integer line) {
        if (line == null) {
            MysqlTreePlanModelBuilder.$$$reportNull$$$0(5);
        }
        if (!this.openNode(line)) {
            return;
        }
        this.parseSubPlans(line);
        Matcher matcher = this.NODE_TYPE.matcher(((MysqlTreeRawPlanData)this.myData).rows.get(line));
        String typeStr = matcher.find() ? matcher.group(1).trim() : ((MysqlTreeRawPlanData)this.myData).rows.get(line);
        PlanModel.NodeType type = TYPE_MAPPING.getOrDefault(typeStr, PlanModel.NodeType.UNKNOWN);
        PlanModel.GenericNode res = this.createNode(line, type, typeStr);
        this.closeNode(res);
    }

    @Override
    protected void parseSubPlans(@NotNull Integer line) {
        int childLevel;
        if (line == null) {
            MysqlTreePlanModelBuilder.$$$reportNull$$$0(6);
        }
        if (line + 1 >= ((MysqlTreeRawPlanData)this.myData).indents.size()) {
            return;
        }
        int level = ((MysqlTreeRawPlanData)this.myData).indents.get(line.intValue());
        int size = ((MysqlTreeRawPlanData)this.myData).rows.size();
        int n = childLevel = line + 1 < size ? ((MysqlTreeRawPlanData)this.myData).indents.get(line + 1) : level;
        if (childLevel <= level) {
            return;
        }
        this.parseSubPlans(childLevel, line + 1);
    }

    private void parseSubPlans(int childLevel, int startIdx) {
        int curLevel;
        int size = ((MysqlTreeRawPlanData)this.myData).rows.size();
        for (int idx = startIdx; idx < size && (curLevel = ((MysqlTreeRawPlanData)this.myData).indents.get(idx).intValue()) >= childLevel; ++idx) {
            if (curLevel != childLevel) continue;
            this.parsePlan(idx);
        }
    }

    @Override
    protected void parseNode(@NotNull Integer line, @NotNull PlanModel.GenericNode node) {
        if (line == null) {
            MysqlTreePlanModelBuilder.$$$reportNull$$$0(7);
        }
        if (node == null) {
            MysqlTreePlanModelBuilder.$$$reportNull$$$0(8);
        }
        node.setRawDescription(this.parseRawDescription(line));
        String row = ((MysqlTreeRawPlanData)this.myData).rows.get(line);
        MysqlTreePlanModelBuilder.processPList(row, "(cost=", (PairConsumer<String, String>)((PairConsumer)(k, v) -> {
            if ("cost".equals(k)) {
                List costs = StringUtil.split((String)v, (String)"..");
                node.setStartupCost(costs.size() < 2 ? null : Double.valueOf(Double.parseDouble((String)costs.get(0))));
                node.setTotalCost(Double.parseDouble((String)ContainerUtil.getLastItem((List)costs)));
            } else if ("rows".equals(k)) {
                node.setPlanNumRows(new BigDecimal((String)v));
            }
        }));
        MysqlTreePlanModelBuilder.processPList(row, "(actual time=", (PairConsumer<String, String>)((PairConsumer)(k, v) -> {
            this.myActual = true;
            if ("actual time".equals(k)) {
                List times = StringUtil.split((String)v, (String)"..");
                node.setActualStartupTime(times.size() < 2 ? null : Double.valueOf(Double.parseDouble((String)times.get(0))));
                node.setActualTotalTime(Double.parseDouble((String)ContainerUtil.getLastItem((List)times)));
            } else if ("rows".equals(k)) {
                node.setActualNumRows(new BigDecimal((String)v));
            }
        }));
    }

    private static void processPList(String row, String prefix, PairConsumer<String, String> consumer) {
        int eq;
        int startIdx = row.indexOf(prefix);
        if (startIdx == -1) {
            return;
        }
        int end = row.indexOf(41, startIdx);
        if (end == -1) {
            end = row.length();
        }
        ++startIdx;
        while ((eq = row.indexOf(61, startIdx)) != -1 && eq < end) {
            String key2 = row.substring(startIdx, eq);
            int e = row.indexOf(32, eq);
            if (e == -1 || e > end) {
                e = end;
            }
            String value = row.substring(eq + 1, e);
            consumer.consume((Object)key2, (Object)value);
            startIdx = e + 1;
        }
    }

    @Override
    protected void parseStatement(@NotNull Integer line) {
        if (line == null) {
            MysqlTreePlanModelBuilder.$$$reportNull$$$0(9);
        }
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull Integer line) {
        if (line == null) {
            MysqlTreePlanModelBuilder.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull Integer line) {
        if (line == null) {
            MysqlTreePlanModelBuilder.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull Integer line) {
        if (line == null) {
            MysqlTreePlanModelBuilder.$$$reportNull$$$0(12);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull Integer line) {
        if (line == null) {
            MysqlTreePlanModelBuilder.$$$reportNull$$$0(13);
        }
        return false;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull Integer line) {
        if (line == null) {
            MysqlTreePlanModelBuilder.$$$reportNull$$$0(14);
        }
        return null;
    }

    static {
        TYPE_MAPPING.put("Rows fetched before execution", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("Filter", PlanModel.NodeType.FILTER);
        TYPE_MAPPING.put("Group aggregate", PlanModel.NodeType.AGGREGATE);
        TYPE_MAPPING.put("Hash", PlanModel.NodeType.HASH_UNIQUE);
        TYPE_MAPPING.put("Deduplicate rows sorted by row ID", PlanModel.NodeType.UNIQUE);
        TYPE_MAPPING.put("Index lookup", PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        TYPE_MAPPING.put("Index scan", PlanModel.NodeType.FULL_INDEX_SCAN);
        TYPE_MAPPING.put("Index range scan", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("Covering index scan", PlanModel.NodeType.FULL_INDEX_SCAN);
        TYPE_MAPPING.put("Covering index lookup", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("Single-row covering index lookup", PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        TYPE_MAPPING.put("Inner hash join", PlanModel.NodeType.HASH_JOIN);
        TYPE_MAPPING.put("Materialize", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("Temporary table with deduplication", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("Temporary table", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("Nested loop inner join", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("Single-row index lookup", PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        TYPE_MAPPING.put("Sort", PlanModel.NodeType.SORT);
        TYPE_MAPPING.put("Table scan", PlanModel.NodeType.SEQ_SCAN);
        TYPE_MAPPING.put("Invalidate materialized tables", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("Union materialize with deduplication", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("Union materialize", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("Union all materialize", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("Stream results", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("Select", PlanModel.NodeType.SUBQUERY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysql/plan/MysqlTreePlanModelBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysql/plan/MysqlTreePlanModelBuilder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

