/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.frontend.shelf.tree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.platform.vcs.impl.frontend.VcsFrontendBundle;
import com.intellij.platform.vcs.impl.frontend.shelf.tree.ChangesBrowserNodeRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.function.ToIntFunction;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ChangesBrowserNode<T>
extends DefaultMutableTreeNode
implements UserDataHolderEx {
    private int myFileCount = -1;
    private int myDirectoryCount = -1;
    private UserDataHolderBase myUserDataHolder;

    protected ChangesBrowserNode(T userObject) {
        super(userObject);
    }

    @Override
    public ChangesBrowserNode<?> getParent() {
        return (ChangesBrowserNode)super.getParent();
    }

    @Nullable
    public <V> V getUserData(@NotNull Key<V> key) {
        UserDataHolderBase holder;
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(0);
        }
        return (V)((holder = this.myUserDataHolder) == null ? null : holder.getUserData(key));
    }

    public <V> void putUserData(@NotNull Key<V> key, @Nullable V value) {
        UserDataHolderBase holder;
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(1);
        }
        if ((holder = this.myUserDataHolder) == null) {
            this.myUserDataHolder = holder = new UserDataHolderBase();
        }
        holder.putUserData(key, value);
    }

    @NotNull
    public <V> V putUserDataIfAbsent(@NotNull Key<V> key, @NotNull V value) {
        UserDataHolderBase holder;
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(2);
        }
        if (value == null) {
            ChangesBrowserNode.$$$reportNull$$$0(3);
        }
        if ((holder = this.myUserDataHolder) == null) {
            this.myUserDataHolder = holder = new UserDataHolderBase();
        }
        Object object = holder.putUserDataIfAbsent(key, value);
        if (object == null) {
            ChangesBrowserNode.$$$reportNull$$$0(4);
        }
        return (V)object;
    }

    public <V> boolean replace(@NotNull Key<V> key, @Nullable V oldValue, @Nullable V newValue) {
        UserDataHolderBase holder;
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(5);
        }
        if ((holder = this.myUserDataHolder) == null) {
            this.myUserDataHolder = holder = new UserDataHolderBase();
        }
        return holder.replace(key, oldValue, newValue);
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        this.resetCounters();
    }

    @Override
    public void remove(int childIndex) {
        super.remove(childIndex);
        this.resetCounters();
    }

    protected boolean isFile() {
        return false;
    }

    protected boolean isDirectory() {
        return false;
    }

    public int getFileCount() {
        if (this.myFileCount == -1) {
            this.myFileCount = (this.isFile() ? 1 : 0) + this.sumForChildren(ChangesBrowserNode::getFileCount);
        }
        return this.myFileCount;
    }

    public int getDirectoryCount() {
        if (this.myDirectoryCount == -1) {
            this.myDirectoryCount = (this.isDirectory() ? 1 : 0) + this.sumForChildren(ChangesBrowserNode::getDirectoryCount);
        }
        return this.myDirectoryCount;
    }

    protected void resetCounters() {
        this.myFileCount = -1;
        this.myDirectoryCount = -1;
    }

    private int sumForChildren(@NotNull ToIntFunction<? super ChangesBrowserNode<?>> counter) {
        if (counter == null) {
            ChangesBrowserNode.$$$reportNull$$$0(6);
        }
        int sum = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            ChangesBrowserNode child = (ChangesBrowserNode)this.getChildAt(i);
            sum += counter.applyAsInt(child);
        }
        return sum;
    }

    @NotNull
    public JBIterable<ChangesBrowserNode<?>> traverse() {
        JBIterable iterable;
        JBIterable jBIterable = iterable = TreeUtil.treeNodeTraverser((TreeNode)this).preOrderDfsTraversal();
        if (jBIterable == null) {
            ChangesBrowserNode.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    public void render(@NotNull JTree tree, @NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (tree == null) {
            ChangesBrowserNode.$$$reportNull$$$0(8);
        }
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(9);
        }
        this.render(renderer, selected, expanded, hasFocus);
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(10);
        }
        renderer.append(this.getTextPresentation());
        this.appendCount(renderer);
    }

    @Nls
    @NotNull
    protected String getCountText() {
        int count = this.getFileCount();
        int dirCount = this.getDirectoryCount();
        Object result = "";
        if (dirCount != 0 || count != 0) {
            result = FontUtil.spaceAndThinSpace() + (dirCount == 0 ? VcsFrontendBundle.message("changes.nodetitle.changecount", count) : (count == 0 ? VcsFrontendBundle.message("changes.nodetitle.directory.changecount", dirCount) : VcsFrontendBundle.message("changes.nodetitle.directory.file.changecount", dirCount, count)));
        }
        String string = result;
        if (string == null) {
            ChangesBrowserNode.$$$reportNull$$$0(11);
        }
        return string;
    }

    protected void appendCount(@NotNull ColoredTreeCellRenderer renderer) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(12);
        }
        renderer.append(this.getCountText(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @Override
    public void setUserObject(Object userObject) {
        if (userObject != this.getUserObject()) {
            Logger.getInstance(ChangesBrowserNode.class).error("Should not replace UserObject for ChangesBrowserNode");
        }
        super.setUserObject(userObject);
    }

    @Nls
    public String getTextPresentation() {
        return this.userObject == null ? "" : this.userObject.toString();
    }

    public T getUserObject() {
        return (T)this.userObject;
    }

    protected void appendParentPath(@NotNull ChangesBrowserNodeRenderer renderer, @Nullable String parentPath) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(13);
        }
        if (parentPath != null) {
            if (parentPath.isEmpty()) {
                return;
            }
            renderer.append(FontUtil.spaceAndThinSpace() + parentPath, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/vcs/impl/frontend/shelf/tree/ChangesBrowserNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/vcs/impl/frontend/shelf/tree/ChangesBrowserNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "traverse";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCountText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sumForChildren";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendCount";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendParentPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 11 -> new IllegalStateException(string);
        };
    }
}

