/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.conflicts;

import com.intellij.CommonBundle;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTrackerBase;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.conflicts.RemoteChangeNotifier;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeTransferOperation
extends TransferOperation.Copy {
    private static final Logger LOG = Logger.getInstance(MergeTransferOperation.class);
    private static final int MAX_STRING_LENGTH = 10;
    private final FileObject mySource;
    private FileObject myTarget;
    private final DeploymentRevisionTracker.Revision myRevision;

    public MergeTransferOperation(@NotNull FileObject source, @NotNull FileObject target, @Nullable DeploymentRevisionTracker.Revision revision) {
        if (source == null) {
            MergeTransferOperation.$$$reportNull$$$0(0);
        }
        if (target == null) {
            MergeTransferOperation.$$$reportNull$$$0(1);
        }
        super(source, target);
        this.mySource = source;
        this.myTarget = target;
        this.myRevision = revision;
    }

    @Override
    @NlsContexts.ProgressText
    public String getProgressText(ExecutionContext context) {
        return WDBundle.message("merging.0", context.isServerSideModification() ? context.getServer().getPresentablePath(this.myTarget) : DeploymentPathUtils.getLocalPath(this.myTarget));
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getDetailedText(ExecutionContext context) {
        if (context.isServerSideModification()) {
            return WDBundle.message("merging.0.with.1", context.getServer().getPresentablePath(this.myTarget), DeploymentPathUtils.getLocalPath(this.mySource));
        }
        return WDBundle.message("merging.0.with.1", DeploymentPathUtils.getLocalPath(this.myTarget), context.getServer().getPresentablePath(this.mySource));
    }

    @Override
    public void execute(ExecutionContext context) throws FileSystemException {
        boolean justLoad;
        if (!this.myTarget.exists()) {
            this.targetNotExist(context);
            return;
        }
        try {
            justLoad = this.myRevision != null && RemoteChangeNotifier.isFileEqualToRevision(this.myTarget, this.myRevision, context);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new CustomFileSystemException(WDBundle.message("failed.to.load.local.file.0.content", this.myTarget.getName().getPath()));
        }
        if (justLoad) {
            super.execute(context);
            return;
        }
        FileObject localFile = context.isServerSideModification() ? this.mySource : this.myTarget;
        URL url = localFile.getURL();
        VirtualFile fileByURL = VfsUtil.findFileByURL((URL)url);
        LOG.assertTrue(fileByURL != null, (Object)("Failed to find file with url " + String.valueOf(url)));
        byte[] targetFileContent = MergeTransferOperation.getContent(this.myTarget, true, context.getProgressIndicator());
        Project project = context.getProject();
        byte[] sourceFileContent = MergeTransferOperation.getContent(this.mySource, false, context.getProgressIndicator());
        context.getProgressIndicator().checkCanceled();
        if (this.myRevision == null && this.isFileUpToDate(context, sourceFileContent, targetFileContent)) {
            MergeTransferOperation.createNewRevision(sourceFileContent, this.mySource, fileByURL, project, context.getServer());
            if (project != null && !project.isDefault()) {
                RemoteChangeNotifier.getInstance(project).updateNotifications(fileByURL, context.getConfig(), context.getServer());
            }
            LOG.debug("Up-to-date, creating revision: " + fileByURL.getPath());
            context.console(WDBundle.message("equal.content.just.making.revision", new Object[0]), ConsoleViewContentType.NORMAL_OUTPUT);
            context.incCounter("transfer.details.upToDate");
            return;
        }
        this.mergeFiles(context, fileByURL, targetFileContent, sourceFileContent);
    }

    private void mergeFiles(@NotNull ExecutionContext context, @NotNull VirtualFile fileByURL, byte @NotNull [] targetFileContent, byte @NotNull [] sourceFileContent) {
        if (context == null) {
            MergeTransferOperation.$$$reportNull$$$0(2);
        }
        if (fileByURL == null) {
            MergeTransferOperation.$$$reportNull$$$0(3);
        }
        if (targetFileContent == null) {
            MergeTransferOperation.$$$reportNull$$$0(4);
        }
        if (sourceFileContent == null) {
            MergeTransferOperation.$$$reportNull$$$0(5);
        }
        Ref result = new Ref();
        Project project = context.getProject();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            byte[] rightContent;
            byte[] leftContent = context.isServerSideModification() ? sourceFileContent : targetFileContent;
            TextMergeRequest diffData = this.createMergeRequest(leftContent, rightContent = context.isServerSideModification() ? targetFileContent : sourceFileContent, this.myRevision, fileByURL, context.getServer(), project, (Ref<Boolean>)result);
            if (diffData != null) {
                DiffManager.getInstance().showMerge(project, (MergeRequest)diffData);
            }
        }, ModalityState.nonModal());
        if (Boolean.TRUE == result.get()) {
            String message = WDBundle.message("file.merged", fileByURL.getPath());
            context.console(message, ConsoleViewContentType.NORMAL_OUTPUT);
            LOG.debug("Merged by user: " + fileByURL.getPath());
            context.incCounter("transfer.details.merged");
        } else {
            String message = WDBundle.message("file.merge.skipped", fileByURL.getPath());
            context.console(message, ConsoleViewContentType.NORMAL_OUTPUT);
            LOG.debug("Merge skipped by user: " + fileByURL.getPath());
            context.incCounter("transfer.details.skippedByUser");
        }
        if (project != null && !project.isDefault()) {
            RemoteChangeNotifier.getInstance(project).updateNotifications(fileByURL, context.getConfig(), context.getServer());
        }
    }

    private static byte @NotNull [] getContent(FileObject file, boolean isLocal, ProgressIndicator pi) throws CustomFileSystemException {
        byte[] byArray;
        try {
            byArray = FileTransferUtil.getContent(file, pi);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new CustomFileSystemException(WDBundle.message(isLocal ? "failed.to.load.local.file.0.content" : "failed.to.load.remote.file.0.content", file.getName().getPath()));
        }
        if (byArray == null) {
            MergeTransferOperation.$$$reportNull$$$0(6);
        }
        return byArray;
    }

    private void targetNotExist(ExecutionContext context) throws FileSystemException {
        Ref load = new Ref();
        if (load.get() == null && this.myRevision != null) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                String message = context.isServerSideModification() ? WDBundle.message("deployed.file.0.was.deleted.and.corresponding.local.file.was.changed.upload.it", context.getServer().getPresentablePath(this.myTarget)) : WDBundle.message("local.file.0.was.deleted.and.corresponding.deployed.file.was.changed.download.it", DeploymentPathUtils.getLocalPath(this.myTarget));
                String title = context.isServerSideModification() ? WDBundle.message("upload.to.0", context.getServer().getName()) : WDBundle.message("update.from.0", context.getServer().getName());
                int loadCode = Messages.showDialog((Project)context.getProject(), (String)message, (String)title, (String[])new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()}, (int)0, (Icon)Messages.getQuestionIcon());
                load.set((Object)(0 == loadCode ? 1 : 0));
            }, ModalityState.nonModal());
        }
        if (this.myRevision == null || Boolean.TRUE == load.get()) {
            super.execute(context);
        } else {
            String message = WDBundle.message("file.skipped", context.isServerSideModification() ? context.getServer().getPresentablePath(this.myTarget) : DeploymentPathUtils.getLocalPath(this.myTarget));
            context.console(message, ConsoleViewContentType.NORMAL_OUTPUT);
            context.incCounter("transfer.details.skippedByUser");
        }
    }

    private boolean isFileUpToDate(ExecutionContext context, byte[] remoteFileContent, byte[] localFileContent) throws FileSystemException {
        if (context.getConfig().getPromptOnRemoteOverwrite() == PublishConfig.PromptOnRemoteOverwrite.CHECK_TIMESTAMP) {
            long currentRemoteTimestamp = this.mySource.getContent().getLastModifiedTime();
            long currentLocalTimestamp = this.myTarget.getContent().getLastModifiedTime();
            return TransferOperation.areTimestampsEqual(currentLocalTimestamp, currentRemoteTimestamp, this.mySource.getFileSystem().getLastModTimeAccuracy() + this.myTarget.getFileSystem().getLastModTimeAccuracy()) && this.mySource.getContent().getSize() == this.myTarget.getContent().getSize();
        }
        return Arrays.equals(remoteFileContent, localFileContent);
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getErrorMessage(ExecutionContext context, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
        if (reason == null) {
            MergeTransferOperation.$$$reportNull$$$0(7);
        }
        String string = WDBundle.message("failed.to.merge.file.0.1", DeploymentPathUtils.getLocalPath(this.myTarget), reason);
        if (string == null) {
            MergeTransferOperation.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
        this.myTarget = MergeTransferOperation.updateOnParentMove(this.myTarget, sourceFrom, sourceTo);
    }

    private static void createNewRevision(byte[] remoteFileContent, FileObject remoteItem, VirtualFile localFile, Project project, Deployable server) {
        DeploymentRevisionTracker tracker = ProjectDeploymentRevisionTracker.getInstance(project);
        if ((long)remoteFileContent.length <= DeploymentRevisionTrackerBase.MAX_FILE_SIZE) {
            try {
                ThrowableComputable revisionFactory = () -> new DeploymentRevisionTracker.Revision(remoteItem.getContent().getLastModifiedTime(), remoteFileContent);
                tracker.putBaseRevision(localFile.getPath(), server.clone(), (ThrowableComputable<? extends DeploymentRevisionTracker.Revision, ? extends IOException>)revisionFactory);
            }
            catch (IOException e) {
                LOG.warn("Failed to load content of remote file " + remoteItem.getName().getPath(), (Throwable)e);
            }
        } else {
            LOG.warn("File " + localFile.getPath() + "  is larger than " + DeploymentRevisionTrackerBase.MAX_FILE_SIZE + " bytes, its base revision will not be stored");
        }
    }

    @Nullable
    private TextMergeRequest createMergeRequest(byte @NotNull [] localFileContent, byte @NotNull [] remoteContentBytes, @Nullable DeploymentRevisionTracker.Revision revision, @NotNull VirtualFile localFile, @NotNull Deployable server, @Nullable Project project, @NotNull Ref<Boolean> successRef) {
        if (localFile == null) {
            MergeTransferOperation.$$$reportNull$$$0(9);
        }
        if (server == null) {
            MergeTransferOperation.$$$reportNull$$$0(10);
        }
        if (successRef == null) {
            MergeTransferOperation.$$$reportNull$$$0(11);
        }
        if (localFileContent == null) {
            MergeTransferOperation.$$$reportNull$$$0(12);
        }
        if (remoteContentBytes == null) {
            MergeTransferOperation.$$$reportNull$$$0(13);
        }
        byte[] middleContent = revision == null ? localFileContent : revision.content;
        String windowTitle = WDBundle.message("title.merge.file.0.1", MergeTransferOperation.getPresentableUrl(localFile), server.getName());
        List<String> titles = Arrays.asList(WDBundle.message("local.file", new Object[0]), WDBundle.message("merge.on.upload.result.title", new Object[0]), WDBundle.message("remote.file", new Object[0]));
        List byteContents = Arrays.asList(localFileContent, middleContent, remoteContentBytes);
        Consumer callback = result -> {
            Document document = FileDocumentManager.getInstance().getCachedDocument(localFile);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (result != MergeResult.CANCEL) {
                MergeTransferOperation.createNewRevision(remoteContentBytes, this.mySource, localFile, project, server);
            }
            successRef.set((Object)(result != MergeResult.CANCEL ? 1 : 0));
        };
        try {
            return DiffRequestFactory.getInstance().createTextMergeRequest(project, localFile, byteContents, windowTitle, titles, callback);
        }
        catch (InvalidDiffRequestException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static String getPresentableUrl(VirtualFile localFile) {
        Object presentableUrl = localFile.getPresentableUrl();
        if (((String)presentableUrl).length() > 10) {
            int index;
            int backslashIndex;
            int beginning = ((String)presentableUrl).length() - 10;
            int slashIndex = ((String)presentableUrl).indexOf(47, beginning);
            if (slashIndex == -1) {
                slashIndex = ((String)presentableUrl).lastIndexOf(47);
            }
            if ((backslashIndex = ((String)presentableUrl).indexOf(92, beginning)) == -1) {
                backslashIndex = ((String)presentableUrl).lastIndexOf(92);
            }
            if ((index = slashIndex != -1 && backslashIndex != -1 ? Math.min(slashIndex, backslashIndex) : Math.max(slashIndex, backslashIndex)) != -1) {
                presentableUrl = "..." + ((String)presentableUrl).substring(index);
            }
        }
        return presentableUrl;
    }

    @Override
    public String toString() {
        return WDBundle.message("merging.0.with.1", DeploymentPathUtils.getLocalPath(this.myTarget), this.mySource.getName().getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileByURL";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFileContent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileContent";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successRef";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFileContent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteContentBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/conflicts/MergeTransferOperation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mergeFiles";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createMergeRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }
}

