/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve.directive;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.ProtoSymbolPath;
import com.intellij.protobuf.lang.psi.ProtoSymbolPathDelegate;
import com.intellij.protobuf.lang.psi.impl.PbElementFactory;
import com.intellij.protobuf.lang.resolve.PbSymbolLookupElement;
import com.intellij.protobuf.lang.resolve.PbSymbolResolver;
import com.intellij.protobuf.lang.resolve.ProtoSymbolPathReference;
import com.intellij.protobuf.lang.resolve.ResolveFilters;
import com.intellij.protobuf.lang.resolve.directive.SchemaComment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MessageComment
extends SchemaComment {
    private SchemaComment fileComment;

    MessageComment(@NotNull PsiComment comment, TextRange keyRange, TextRange nameRange) {
        if (comment == null) {
            MessageComment.$$$reportNull$$$0(0);
        }
        super(comment, keyRange, nameRange, SchemaComment.Type.MESSAGE);
    }

    void setFileComment(SchemaComment comment) {
        this.fileComment = comment;
    }

    @Override
    @Nullable
    public PsiReference getReference() {
        List<PsiReference> references = this.getAllReferences();
        if (references.isEmpty()) {
            return null;
        }
        return references.get(0);
    }

    @Override
    public List<PsiReference> getAllReferences() {
        final PsiComment comment = this.getComment();
        final TextRange nameRange = this.getNameRange();
        if (this.fileComment == null || nameRange == null) {
            return ImmutableList.of();
        }
        PsiReference fileReference = this.fileComment.getReference();
        if (fileReference == null) {
            return ImmutableList.of();
        }
        String name = this.getName();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return ImmutableList.of();
        }
        PsiElement file = fileReference.resolve();
        if (!(file instanceof PbFile)) {
            return ImmutableList.of();
        }
        final PbFile pbFile = (PbFile)file;
        final PbTypeName parsedType = ((PbElementFactory.TypeNameBuilder)PbElementFactory.getInstance((PsiFile)pbFile).typeNameBuilder().setParent(pbFile)).setName(name).build();
        parsedType.setDelegateOverride(new ProtoSymbolPathDelegate(){

            @Override
            public PsiReference getReference(ProtoSymbolPath path) {
                TextRange symbolRange = path.getSymbol().getTextRange().shiftRight(nameRange.getStartOffset());
                return new ProtoSymbolPathReference((PsiElement)comment, symbolRange, path, PbSymbolResolver.forFileExports(pbFile), parsedType.isFullyQualified() ? null : pbFile.getPrimarySymbolOwner().getChildScope(), ResolveFilters.packageOrMessage(), ResolveFilters.packageOrMessage(), PbSymbolLookupElement::new);
            }
        });
        ImmutableList.Builder references = ImmutableList.builder();
        for (ProtoSymbolPath path = parsedType.getSymbolPath(); path != null; path = path.getQualifier()) {
            PsiReference ref = path.getReference();
            if (ref == null) continue;
            references.add((Object)ref);
        }
        return references.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/protobuf/lang/resolve/directive/MessageComment", "<init>"));
    }
}

